<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;

class GenerateCustomToken extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:generate-custom-token';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Generate custom token for api token';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $randomString = Str::random(100);
        $token = Hash::make($randomString);
        $token = str_replace("$", "", $token);

        $this->info("Success Generate custom token");
        $this->info("Token : " . $token);
    }
}
