<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

use App\Models\KelengkapanData\KelengkapanData;
use App\Jobs\KelengkapanDataCrmJob;

class KelengkapanDataCheck extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'scheduler:kelengkapan-data-check';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'fungsi untuk mengecek data registrasi yg gagal hit api registrasi Relyon API, dan mengirim ulang data tersebut';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        KelengkapanData::where('is_send', 0)->chunk(100, function ($KelengkapanDatas) {
            foreach ($KelengkapanDatas as $KelengkapanData) {
                KelengkapanDataCrmJob::dispatch($KelengkapanData);
            }
        });
    }
}
