<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

use App\Models\Registration;
use App\Jobs\RegistrationRelyonJob;

class RegistrationCheck extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'scheduler:registration-check';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'fungsi untuk mengecek data registrasi yg gagal hit api registrasi Relyon API, dan mengirim ulang data tersebut';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        Registration::where('is_send', 0)->chunk(100, function ($registrations) {
            foreach ($registrations as $registration) {
                RegistrationRelyonJob::dispatch($registration);
            }
        });
    }
}
