<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

use DB;
use Exception;
use App\Models\TempModel;
use App\Models\Geo\AreaInfo;

class TempCheck extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:temp';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'temp';

    /**
     * Execute the console command.
     */
    public function handle()
    {

        DB::beginTransaction();
        try {
            
            $TempModel = TempModel::get();
            foreach ($TempModel as $key => $val) {
                AreaInfo::create([
                    'id' => $val->id,
                    'area_id' => $val->area_id,
                    'geo_province_id' => $val->geo_province_id,
                    'geo_town_id' => $val->geo_town_id,
                    'geo_district_id' => $val->geo_district_id,
                    'geo_village_id' => $val->geo_village_id,
                    'is_deleted' => $val->is_deleted
                ]);
            }

            DB::commit();
            $this->info("sukses");
        } catch (Exception $e) {
            DB::rollBack();
            \Log::info($e->getMessage());
            $this->info("gagal : ".$e->getMessage());
        }
    }
}
