<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use Maatwebsite\Excel\Concerns\WithCustomValueBinder;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use PhpOffice\PhpSpreadsheet\Cell\StringValueBinder;
use PhpOffice\PhpSpreadsheet\Cell\DataType;

use App\Models\KelengkapanData\KelengkapanData;

class KelengkapanDataExport implements FromCollection, WithMapping, WithHeadings, WithColumnFormatting, WithCustomValueBinder
{

    protected $request;
    protected $counter = 1;
    protected $gasTools = [];
    protected $fuels = [];

    public function __construct($request)
    {
        $this->request = $request;
    }

    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        $data = KelengkapanData::with([
            'province',
            'town'
        ]);

        if ($this->request->has('search')) {
            $data = $data->where('customer_id', 'like', '%'.$this->request->search.'%')
                ->orWhere('nama_pelanggan', 'like', '%'.$this->request->search.'%')
                ->orWhere('no_telpon', 'like', '%'.$this->request->search.'%')
                ->orWhere('email', 'like', '%'.$this->request->search.'%');
        }

        return $data->orderBy('created_at', 'DESC')->get();
    }

    public function map($row): array
    {
        $data = [];

        if ($row) {
            $data = [
                'No' => $this->counter++,
                'Id Pelanggan' => $row->customer_id,
                'Nama pelanggan' => $row->nama,
                'Provinsi' => !empty($row->province) ? $row->province->name : '',
                'Kota/Kabupaten' => !empty($row->town) ? $row->town->name : '',
                'Is PK' => $row->is_pk_text,
                'Is Badan Hukum' => $row->is_badan_hukum_text,
                'Is NPWP' => $row->is_npwp_text,
                'NPWP' => !empty($row->npwp) ? $row->npwp : '',
                'No KTP' => $row->ktp,
                'KTP Url' => $row->ktp_url_relyon,
                'Nama KTP' => $row->nama_ktp,
                'Alamat KTP' => $row->alamat_ktp,
                'Alamat Lokasi Pemasangan' => $row->alamat_lokasi_pemasangan,
                'No Telpon' => $row->no_telpon,
                'Email' => $row->email,
                'Is Sync CRM' => $row->is_send_text,
                'Is Send Email' => $row->is_send_email
            ];
        }
    
        return $data;
    }

    public function headings(): array
    {
        $headers = [
            'No',
            'Id Pelanggan',
            'Nama pelanggan',
            'Provinsi',
            'Kota/Kabupaten',
            'Is PK',
            'Is Badan Hukum',
            'Is NPWP',
            'NPWP',
            'No KTP',
            'KTP Url',
            'Nama KTP',
            'Alamat KTP',
            'Alamat Lokasi Pemasangan',
            'No Telpon',
            'Email',
            'Is Sync CRM',
            'Is Send Email'
        ];

        return $headers;
    }

    public function columnFormats(): array
    {
        return [
            'A' => NumberFormat::FORMAT_NUMBER
        ];
    }

    public function bindValue(\PhpOffice\PhpSpreadsheet\Cell\Cell $cell, $value)
    {
        $cell->setValueExplicit($value, DataType::TYPE_STRING);
        return true;
    }
}
