<?php

namespace App\Helpers;

use GuzzleHttp\Client;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Log;
use Pgn\Enum\ResponseEnum;

class GaClient
{
    const WA_MESSAGE_TYPE_TEMPLATE_MESSAGE = 'template_message';
    const WA_MESSAGE_TYPE_PLAIN_MESSAGE = 'message';

    protected $client;

    public function __construct()
    {
        
        $this->client = new Client(['verify' => false]);
        $this->headerParams = ['headers' => ['Authorization' => 'Bearer ' . env('GA_API_KEY')]];

    }

    /**
     * @param $to
     * @param $subject
     * @param $body
     * @param array $attachments
     * @return bool
     */
    public function sendEmail($to, $subject, $body, $attachments = [])
    {
        $requestUrl = env('GA_EMAIL_SERVICE_URL');
        $params = [
            'multipart' => [
                [
                    'name' => 'email_address',
                    'contents' => $to
                ],
                [
                    'name' => 'subject',
                    'contents' => $subject
                ],
                [
                    'name' => 'body',
                    'contents' => $body
                ],

            ]
        ];

        if ($attachments) {
            foreach ($attachments as $attachment) {
                $params['multipart'][] = [
                    'name' => 'attachment[]',
                    'contents' => fopen($attachment['file_path'], 'r')

                ];
                $params['multipart'][] =
                    [
                        'name' => 'attachment_name[]',
                        'contents' => $attachment['file_name']
                    ];
            }
        }
        
        Log::info("payload notif email = " . json_encode($params));
        
        $params = array_merge($params, $this->headerParams);
        $response = $this->client->request('POST', $requestUrl, $params);
        $result = json_decode((string)$response->getBody());
        if ($response->getStatusCode() == 200 && $result->status == true) {
            return true;
        }

        return false;
    }

    /**
     * @param $to
     * @param $subject
     * @param $body
     * @param array $attachments
     * @param array $cc
     * @param array $bcc
     * @return bool
     */
    public function sendEmailWithCC($to, $subject, $body, $attachments = [], $cc = [], $bcc = [])
    {

        $requestUrl = env('GA_EMAIL_SERVICE_URL');
        $params = [
            'multipart' => [
                [
                    'name' => 'email_address',
                    'contents' => $to
                ],
                [
                    'name' => 'cc',
                    'contents' => $cc
                ],
                [
                    'name' => 'bcc',
                    'contents' => $bcc
                ],
                [
                    'name' => 'subject',
                    'contents' => $subject
                ],
                [
                    'name' => 'body',
                    'contents' => $body
                ],

            ]
        ];

        if ($attachments) {
            foreach ($attachments as $attachment) {
                $params['multipart'][] = [
                    'name' => 'attachment[]',
                    'contents' => fopen($attachment['file_path'], 'r')

                ];
                $params['multipart'][] =
                    [
                        'name' => 'attachment_name[]',
                        'contents' => $attachment['file_name']
                    ];
            }
        }
        
        Log::info("payload notif email cc = " . json_encode($params));
        
        $params = array_merge($params, $this->headerParams);
        $response = $this->client->request('POST', $requestUrl, $params);
        $result = json_decode((string)$response->getBody());
        if ($response->getStatusCode() == 200 && $result->status == true) {
            return true;
        }

        return false;
    }

}