<?php 

use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\ValidationException;

if (!function_exists('validation')) {
    function validation($request, $rule)
    {
        $validator = Validator::make($request->all(), $rule);
    
        if ($validator->fails()) {
            throw new ValidationException($validator);        
        }
    }
}

if (!function_exists('regexValidString')) {
    function regexValidString()
    {
        return "regex:/^[a-zA-Z0-9\s\_\.\-\@\,\(\)\/\&\\\]+$/";
    }
}

if (!function_exists('regexValidNumber')) {
    function regexValidNumber()
    {
        return "regex:/^[0-9]+$/";
    }
}

if (!function_exists('regexValidPhone')) {
    function regexValidPhone()
    {
        return "regex:/^62[1-9][0-9]*$/";
    }
}
if (!function_exists('regexValidBase64')) {
    function regexValidBase64()
    {
        return "regex:/^[a-zA-Z0-9\s\/\;,+-_:=]+$/";
    }
}

?>