<?php

namespace App\Http\Controllers\Brosur;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Validation\ValidationException;

use GuzzleHttp\Client;
use Illuminate\Support\Facades\Storage;
use Log;
use DB;
use Exception;
use Carbon\Carbon;
use Maatwebsite\Excel\Facades\Excel;

use App\Models\Brosur\Brosur;

class BrosurController extends Controller
{
    public function __construct()
    {
        
    }

    public function index(Request $request)
    {
        try {

            $Brosur = Brosur::whereNull('deleted_at')->first();

            return response()->json([
                'status' => true,
                'message' => 'Berhasil mengambil data',
                'data' => $Brosur
            ], 200);

        } catch (Exception $e) {
            Log::error('BrosurController - index : '. $e->getMessage());
            return response()->json([
                'status' => false,
                'message' => 'Gagal menghubungkan ke server'
            ], 500);
        }
    }

    public function uploadFile(Request $request)
    {

        try {
            validation($request, [
                'file' => 'required|mimes:pdf|max:10000'
            ]);
        } catch (ValidationException $e) {
            Log::error('BrosurController - uploadFile - validasi : '. json_encode($e->validator->errors()));
            return response()->json([
                'status' => false,
                'message' => 'Failed validation',
                'errors' => $e->validator->errors()
            ], 422);
        }

        try {
            $file = $request->file('file');
        
            $client = new Client(['verify' => false]);

            $request = [
                'multipart' => [
                    [
                        'name' => 'file',
                        'contents' => file_get_contents($file->getRealPath()),
                        'filename' => $file->getClientOriginalName(),
                        'ext' => $file->getClientOriginalExtension()
                    ],
                ],
                'headers' => [
                    'client_id' => env('RELYON_CLIENT_ID', ''),
                    'client_secret' => env('RELYON_CLIENT_SECRET', ''),
                    'Authorization' => 'Bearer '.env('RELYON_TOKEN', '')
                ]
            ];

            $response = $client->request('POST', env('RELYON_UPLOAD_FILE'), $request);
            
            $result = json_decode((string)$response->getBody());
            
            if ($response->getStatusCode() == 200 && $result->status == true) {
                
                $Brosur = Brosur::first();
                
                if (empty($Brosur)) {
                    $Brosur = new Brosur;
                    $Brosur->create([
                        'url' => $result->url
                    ]);
                } else {
                    $Brosur->update([
                        'url' => $result->url
                    ]);
                }

                $Brosur = Brosur::first();

                return response()->json([
                    'status' => true,
                    'data' => $Brosur,
                    'message' => 'Berhasil upload file'
                ], 200);
            }

            return response()->json([
                'status' => false,
                'data' => [],
                'message' => 'Gagal upload file'
            ], 400);

        } catch (Exception $e) {
            Log::error('BrosurController - uploadFile : '. $e->getMessage());
            return response()->json([
                'status' => false,
                'data' => [],
                'message' => 'Gagal menghubungkan ke server'
            ], 500);
        }
    }

}
