<?php

namespace App\Http\Controllers\FilePernyataan;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Validation\ValidationException;

use GuzzleHttp\Client;
use Illuminate\Support\Facades\Storage;
use Log;
use DB;
use Exception;
use Carbon\Carbon;
use Maatwebsite\Excel\Facades\Excel;

use App\Models\FilePernyataan\FilePernyataan;

class FilePernyataanController extends Controller
{
    public function __construct()
    {
        
    }

    public function index(Request $request)
    {
        try {

            $FilePernyataan = FilePernyataan::whereNull('deleted_at')->first();

            return response()->json([
                'status' => true,
                'message' => 'Berhasil mengambil data',
                'data' => $FilePernyataan
            ], 200);

        } catch (Exception $e) {
            Log::error('FilePernyataanController - index : '. $e->getMessage());
            return response()->json([
                'status' => false,
                'message' => 'Gagal menghubungkan ke server'
            ], 500);
        }
    }

    public function uploadFile(Request $request)
    {

        try {
            validation($request, [
                'file' => 'required|mimes:pdf|max:10000'
            ]);
        } catch (ValidationException $e) {
            Log::error('FilePernyataanController - uploadFile - validasi : '. json_encode($e->validator->errors()));
            return response()->json([
                'status' => false,
                'message' => 'Failed validation',
                'errors' => $e->validator->errors()
            ], 422);
        }

        try {
            $file = $request->file('file');
        
            $client = new Client(['verify' => false]);

            $request = [
                'multipart' => [
                    [
                        'name' => 'file',
                        'contents' => file_get_contents($file->getRealPath()),
                        'filename' => $file->getClientOriginalName(),
                        'ext' => $file->getClientOriginalExtension()
                    ],
                ],
                'headers' => [
                    'client_id' => env('RELYON_CLIENT_ID', ''),
                    'client_secret' => env('RELYON_CLIENT_SECRET', ''),
                    'Authorization' => 'Bearer '.env('RELYON_TOKEN', '')
                ]
            ];

            $response = $client->request('POST', env('RELYON_UPLOAD_FILE'), $request);
            
            $result = json_decode((string)$response->getBody());
            
            if ($response->getStatusCode() == 200 && $result->status == true) {
                
                $FilePernyataan = FilePernyataan::first();

                if (empty($FilePernyataan)) {
                    $FilePernyataan = new FilePernyataan;
                    $FilePernyataan->create([
                        'url' => $result->url
                    ]);
                } else {
                    $FilePernyataan->update([
                        'url' => $result->url
                    ]);
                }

                $FilePernyataan = FilePernyataan::first();

                return response()->json([
                    'status' => true,
                    'data' => $FilePernyataan,
                    'message' => 'Berhasil upload file'
                ], 200);
            }

            return response()->json([
                'status' => false,
                'data' => [],
                'message' => 'Gagal upload file'
            ], 400);

        } catch (Exception $e) {
            Log::error('FilePernyataanController - uploadFile : '. $e->getMessage());
            return response()->json([
                'status' => false,
                'data' => [],
                'message' => 'Gagal menghubungkan ke server'
            ], 500);
        }
    }

}
