<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Models\Geo\Province;
use App\Models\Geo\Town;
use App\Models\Geo\District;
use App\Models\Geo\Village;
use App\Models\Geo\HousingArea;
use App\Models\Geo\BuildingType;
use App\Models\Geo\StatusLocation;

use Illuminate\Validation\ValidationException;

class GeoController extends Controller
{
    public function __construct()
    {
        
    }

    public function getProvince()
    {
        $Province = Province::where("is_deleted", 0)
        ->orderBy("name", "ASC")
        ->get();
        
        return response()->json([
            "status" => true,
            "data" => $Province,
            "message" => "Berhasil mengambil data"
        ]);
    }

    public function getTown(Request $request)
    {
        try {
            validation($request, [
                'geo_province_id' => 'required|numeric|exists:geo_provinces,id,is_deleted,0'
            ]);
        } catch (ValidationException $e) {
            return response()->json([
                'status' => false,
                'message' => 'Failed validation',
                'errors' => $e->validator->errors()
            ], 422);
        }

        $Town = Town::where("geo_province_id", $request->geo_province_id)
        ->where("is_deleted", 0)
        ->orderBy("name", "ASC")
        ->get();
        
        return response()->json([
            "status" => true,
            "data" => $Town,
            "message" => "Berhasil mengambil data"
        ]);
    }

    public function getDistrict(Request $request)
    {
        try {
            validation($request, [
                'geo_town_id' => 'required|numeric|exists:geo_towns,id,is_deleted,0'
            ]);
        } catch (ValidationException $e) {
            return response()->json([
                'status' => false,
                'message' => 'Failed validation',
                'errors' => $e->validator->errors()
            ], 422);
        }

        $Town = District::where("geo_town_id", $request->geo_town_id)
        ->where("is_deleted", 0)
        ->orderBy("name", "ASC")
        ->get();
        
        return response()->json([
            "status" => true,
            "data" => $Town,
            "message" => "Berhasil mengambil data"
        ]);
    }

    public function getVillage(Request $request)
    {
        try {
            validation($request, [
                'geo_district_id' => 'required|numeric|exists:geo_districts,id,is_deleted,0'
            ]);
        } catch (ValidationException $e) {
            return response()->json([
                'status' => false,
                'message' => 'Failed validation',
                'errors' => $e->validator->errors()
            ], 422);
        }

        $Town = Village::where("geo_district_id", $request->geo_district_id)
        ->where("is_deleted", 0)
        ->orderBy("name", "ASC")
        ->get();
        
        return response()->json([
            "status" => true,
            "data" => $Town,
            "message" => "Berhasil mengambil data"
        ]);
    }

    public function getHousingArea(Request $request)
    {

        try {
            validation($request, [
                'geo_province_id' => 'required|numeric|exists:geo_provinces,id,is_deleted,0',
                'geo_town_id' => 'required|numeric|exists:geo_towns,id,is_deleted,0',
                'geo_district_id' => 'required|numeric|exists:geo_districts,id,is_deleted,0',
                'geo_village_id' => 'required|numeric|exists:geo_villages,id,is_deleted,0'
            ]);
        } catch (ValidationException $e) {
            return response()->json([
                'status' => false,
                'message' => 'Failed validation',
                'errors' => $e->validator->errors()
            ], 422);
        }

        $Town = HousingArea::where("geo_province_id", $request->geo_province_id)
        ->where("geo_town_id", $request->geo_town_id)
        ->where("geo_district_id", $request->geo_district_id)
        ->where("geo_village_id", $request->geo_village_id)
        ->where("is_deleted", 0)
        ->orderBy("name", "ASC")
        ->get();
        
        return response()->json([
            "status" => true,
            "data" => $Town,
            "message" => "Berhasil mengambil data"
        ]);
    }

    public function getBuildingType()
    {
        $BuildingType = BuildingType::where("is_deleted", 0)
        ->orderBy('sort', 'ASC')
        ->get();
        
        return response()->json([
            "status" => true,
            "data" => $BuildingType,
            "message" => "Berhasil mengambil data"
        ]);
    }

    public function getStatusLocation()
    {
        $StatusLocation = StatusLocation::where("is_deleted", 0)
        ->orderBy('sort', 'ASC')
        ->get();
        
        return response()->json([
            "status" => true,
            "data" => $StatusLocation,
            "message" => "Berhasil mengambil data"
        ]);
    }
}
