<?php

namespace App\Http\Controllers\KebenaranData;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Validation\ValidationException;

use GuzzleHttp\Client;
use Illuminate\Support\Facades\Storage;
use Log;
use DB;
use Exception;
use Carbon\Carbon;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Support\Facades\Validator;

use App\Models\KebenaranData\KebenaranData;

class KebenaranDataController extends Controller
{
    public function __construct()
    {
        
    }

    public function index(Request $request)
    {
        try {

            $KebenaranData = KebenaranData::whereNull('deleted_at')->first();

            return response()->json([
                'status' => true,
                'message' => 'Berhasil mengambil data',
                'data' => $KebenaranData
            ], 200);

        } catch (Exception $e) {
            Log::error('KebenaranDataController - index : '. $e->getMessage());
            return response()->json([
                'status' => false,
                'message' => 'Gagal menghubungkan ke server'
            ], 500);
        }
    }

    public function update(Request $request)
    {

        try {
            validation($request, [
                'konten' => 'required|'.regexValidBase64()
            ]);
        } catch (ValidationException $e) {
            Log::error('KebenaranDataController - update - validasi : '. json_encode($e->validator->errors()));
            return response()->json([
                'status' => false,
                'message' => 'Failed validation',
                'errors' => $e->validator->errors()
            ], 422);
        }

        try {
            
            if (base64_encode(base64_decode($request->konten, true)) !== $request->konten) {
                return response()->json([
                    'status' => false,
                    'data' => [],
                    'message' => 'Isian Konten tidak valid'
                ], 422);
            }
            
            $KebenaranData = KebenaranData::first();

            if (empty($KebenaranData)) {
                $KebenaranData = new KebenaranData;
                $KebenaranData->create([
                    'konten' => $request->konten
                ]);
            } else {
                $KebenaranData->update([
                    'konten' => $request->konten
                ]);
            }

            $KebenaranData = KebenaranData::first();

            return response()->json([
                'status' => true,
                'data' => $KebenaranData,
                'message' => 'Berhasil menyimpan data'
            ], 200);

        } catch (Exception $e) {
            Log::error('KebenaranDataController - update : '. $e->getMessage());
            return response()->json([
                'status' => false,
                'data' => [],
                'message' => 'Gagal menghubungkan ke server'
            ], 500);
        }
    }

}
