<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Validation\ValidationException;

use GuzzleHttp\Client;
use Illuminate\Support\Facades\Storage;
use Log;
use DB;
use Exception;
use Carbon\Carbon;
use Maatwebsite\Excel\Facades\Excel;

use App\Models\Brosur\Brosur;
use App\Models\FilePernyataan\FilePernyataan;
use App\Models\KebenaranData\KebenaranData;
use App\Models\KetentuanUmum\KetentuanUmum;

class KontenController extends Controller
{
    public function __construct()
    {
        
    }

    public function index(Request $request)
    {
        try {

            $Brosur = Brosur::select('url')->whereNull('deleted_at')->first();
            $FilePernyataan = FilePernyataan::select('url')->whereNull('deleted_at')->first();
            $KebenaranData = KebenaranData::select('konten')->whereNull('deleted_at')->first();
            $KetentuanUmum = KetentuanUmum::select('konten')->whereNull('deleted_at')->first();

            return response()->json([
                'status' => true,
                'message' => 'Berhasil mengambil data',
                'data' => [
                    'brosur' => $Brosur,
                    'file_pernyataan' => $FilePernyataan,
                    'kebenaran_data' => $KebenaranData,
                    'ketentuan_umum' => $KetentuanUmum
                ]
            ], 200);

        } catch (Exception $e) {
            Log::error('KontenController - index : '. $e->getMessage());
            return response()->json([
                'status' => false,
                'message' => 'Gagal menghubungkan ke server'
            ], 500);
        }
    }

}
