<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Models\Tools\Fuels;
use App\Models\Tools\FuelUnits;
use App\Models\Tools\GasTools;
use App\Models\Tools\ElectricalPower;

class ToolsController extends Controller
{

    public function getGasTools()
    {
        $GasTools = GasTools::where("is_deleted", 0)
        ->orderBy('sort', 'ASC')
        ->get();
        
        return response()->json([
            "status" => true,
            "data" => $GasTools,
            "message" => "Berhasil mengambil data"
        ]);
    }

    public function getFuels()
    {
        $Fuels = Fuels::where("is_deleted", 0)
        ->orderBy('sort', 'ASC')
        ->get();
        
        return response()->json([
            "status" => true,
            "data" => $Fuels,
            "message" => "Berhasil mengambil data"
        ]);
    }

    public function getElectricalPower()
    {
        $ElectricalPower = ElectricalPower::where("is_deleted", 0)
        ->orderBy('id', 'ASC')
        ->get();
        
        return response()->json([
            "status" => true,
            "data" => $ElectricalPower,
            "message" => "Berhasil mengambil data"
        ]);
    }

}
