<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

use App\Models\KelengkapanData\KelengkapanData;
use App\Http\Controllers\KelengkapanData\KelengkapanDataController;
use Log;

class KelengkapanDataCrmJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    private $KelengkapanData;
    /**
     * Create a new job instance.
     */
    public function __construct(KelengkapanData $KelengkapanData)
    {
        $this->KelengkapanData = $KelengkapanData;
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        Log::info('Job KelengkapanDataCrmJob BEGIN for id : '.$this->KelengkapanData->id);
        $callApiRegsitrasi = (new KelengkapanDataController)->callApiUpdateProfile($this->KelengkapanData);
        Log::info('Job KelengkapanDataCrmJob END for id : '.$this->KelengkapanData->id);
    }
}
