<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

use App\Models\Registration;
use App\Http\Controllers\RegistrationCapelController;
use Log;

class RegistrationRelyonJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    private $Registration;
    /**
     * Create a new job instance.
     */
    public function __construct(Registration $Registration)
    {
        $this->Registration = $Registration;
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        Log::info('Job RegistrationRelyonJob BEGIN for id : '.$this->Registration->id);
        $callApiRegsitrasi = (new RegistrationCapelController)->callApiRegsitrasi($this->Registration);
        Log::info('Job RegistrationRelyonJob END for id : '.$this->Registration->id);
    }
}
