<?php

namespace App\Models\Geo;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

use App\Models\Geo\AreaInfo;

class Area extends Model
{
    use HasFactory;

    protected $table = "areas";
    protected $primaryKey = 'id';
    protected $keyType = 'string';

    protected $hidden = [
        'is_deleted',
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    // RELASI
    public function areaInfo()
    {
        return $this->hasMany(AreaInfo::class, 'area_id', 'id');
    }
}
