<?php

namespace App\Models\Geo;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

use App\Models\Geo\AreaInfo;

class Town extends Model
{
    use HasFactory;

    protected $table = "geo_towns";

    protected $hidden = [
        'is_deleted',
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    public function areaInfo()
    {
        return $this->hasMany(AreaInfo::class, 'geo_town_id', 'id');
    }
}
