<?php

namespace App\Models\KelengkapanData;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

use App\Models\Geo\Province;
use App\Models\Geo\Town;
use App\Models\Geo\District;
use App\Models\Geo\Village;
use App\Models\Geo\StatusLocation;
use App\Models\Geo\BuildingType;
use App\Models\Geo\HousingArea;
use App\Models\Tools\ElectricalPower;
use App\Models\Tools\FuelUsages;
use App\Models\Tools\GasToolUsages;

class KelengkapanData extends Model
{
    use HasFactory;

    protected $table = "kelengkapan_data";

    protected $appends = [
        "province_name",
        "town_name",
        "is_pk_text",
        "is_badan_hukum_text",
        "is_npwp_text",
        "is_send_text",
        "is_send_email_text"
    ];

    protected $fillable = [
        'nama_pelanggan',
        'customer_id',
        'geo_province_id',
        'geo_town_id',
        'is_pk',
        'is_badan_hukum',
        'is_npwp',
        'npwp',
        'ktp',
        'ktp_url',
        'ktp_url_relyon',
        'nama_ktp',
        'alamat_ktp',
        'alamat_lokasi_pemasangan',
        'no_telpon',
        'email',
        'is_send',
    ];

    // RELASI
    public function province()
    {
        return $this->belongsTo(Province::class, 'geo_province_id', 'id');
    }

    public function town()
    {
        return $this->belongsTo(Town::class, 'geo_town_id', 'id');
    }

    // ASSESOR

    public function getKtpUrlRelyonAttribute($value)
    {
        return !empty($value) ? env('SCDN_URL').$value : '';
    }

    public function getProvinceNameAttribute()
    {
        return !empty($this->province) ? $this->province->name : '';
    }

    public function getTownNameAttribute()
    {
        return !empty($this->town) ? $this->town->name : '';
    }

    public function getIsPkTextAttribute()
    {
        return !empty($this->is_pk) && $this->is_pk == 1 ? 'Ya' : 'Tidak';
    }

    public function getIsBadanHukumTextAttribute()
    {
        return !empty($this->is_badan_hukum) && $this->is_badan_hukum == 1 ? 'Ya' : 'Tidak';
    }

    public function getIsNpwpTextAttribute()
    {
        return !empty($this->is_npwp) && $this->is_npwp == 1 ? 'Ya' : 'Tidak';
    }

    public function getIsSendTextAttribute()
    {
        return !empty($this->is_send) && $this->is_send == 1 ? 'True' : 'False';
    }

    public function getIsSendEmailTextAttribute()
    {
        return !empty($this->is_send_email) && $this->is_send_email == 1 ? 'True' : 'False';
    }
}
