<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

use App\Models\Tools\FuelUsages;
use App\Models\Tools\GasToolUsages;

class Registration extends Model
{
    use HasFactory;

    protected $table = "registrations";

    protected $fillable = [
        'form_id',
        'kebutuhan_pelanggan',
        'geo_province_id',
        'geo_town_id',
        'geo_district_id',
        'geo_village_id',
        'housing_area_id',
        'nama_perumahan_jalan_utama',
        'alamat',
        'rt',
        'rw',
        'kode_pos',
        'building_type_id',
        'nama_pemilik_bangunan',
        'no_telpon_pemilik_bangunan',
        'status_lokasi_pemasangan',
        'latitude',
        'longitude',
        'status_location_id',
        'nama',
        'ktp',
        'no_telpon',
        'email',
        'electrical_power_id',
        'ktp_url',
        'rekening_listrik_url',
        'ktp_url_relyon',
        'rekening_listrik_url_relyon',
        'is_send'
    ];

    protected $hidden = [
        'updated_at',
        'deleted_at',
    ];

    public function fuelUsages()
    {
        return $this->hasMany(FuelUsages::class, 'registration_id', 'id');
    }

    public function gasToolUsages()
    {
        return $this->hasMany(GasToolUsages::class, 'registration_id', 'id');
    }
}
