<?php

namespace App\Models\Registration;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

use App\Models\Geo\Province;
use App\Models\Geo\Town;
use App\Models\Geo\District;
use App\Models\Geo\Village;
use App\Models\Geo\StatusLocation;
use App\Models\Geo\BuildingType;
use App\Models\Geo\HousingArea;
use App\Models\Tools\ElectricalPower;
use App\Models\Tools\FuelUsages;
use App\Models\Tools\GasToolUsages;

class Registration extends Model
{
    use HasFactory;

    protected $table = "registrations";

    protected $appends = [
        "kebutuhan_pelanggan_text",
        "province_name",
        "town_name"
    ];

    const KEBUTUHAN_PELANGGAN = [
        1 => 'Kebutuhan Sendiri / Rumah Tangga',
        2 => 'Kebutuhan Komersial / Jasa (tempat makan, laundry, perkantoran, dan lainnya)'
    ];

    // RELASI
    public function province()
    {
        return $this->belongsTo(Province::class, 'geo_province_id', 'id');
    }

    public function town()
    {
        return $this->belongsTo(Town::class, 'geo_town_id', 'id');
    }

    public function district()
    {
        return $this->belongsTo(District::class, 'geo_district_id', 'id');
    }

    public function village()
    {
        return $this->belongsTo(Village::class, 'geo_village_id', 'id');
    }

    public function housingArea()
    {
        return $this->belongsTo(HousingArea::class, 'housing_area_id', 'id');
    }

    public function buildingType()
    {
        return $this->belongsTo(BuildingType::class, 'building_type_id', 'id');
    }

    public function statusLocation()
    {
        return $this->belongsTo(StatusLocation::class, 'status_location_id', 'id');
    }

    public function electricalPower()
    {
        return $this->belongsTo(ElectricalPower::class, 'electrical_power_id', 'id');
    }

    public function fuelUsages()
    {
        return $this->hasMany(FuelUsages::class, 'registration_id', 'id');
    }

    public function gasToolUsages()
    {
        return $this->hasMany(GasToolUsages::class, 'registration_id', 'id');
    }


    // ASSESOR

    public function getKtpUrlRelyonAttribute($value)
    {
        return !empty($value) ? env('SCDN_URL').$value : '';
    }
    
    public function getRekeningListrikUrlRelyonAttribute($value)
    {
        return !empty($value) ? env('SCDN_URL').$value : '';
    }

    public function getKebutuhanPelangganTextAttribute()
    {
        return !empty($this->kebutuhan_pelanggan) ? self::KEBUTUHAN_PELANGGAN[$this->kebutuhan_pelanggan] : '';
    }

    public function getProvinceNameAttribute()
    {
        return !empty($this->province) ? $this->province->name : '';
    }

    public function getTownNameAttribute()
    {
        return !empty($this->town) ? $this->town->name : '';
    }
}
