<?php

namespace App\Models\Tools;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Fuels extends Model
{
    use HasFactory;

    protected $table = "fuels";
    protected $appends = [
        "full_icon_url"
    ];

    protected $hidden = [
        'is_deleted',
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    public function getFullIconUrlAttribute()
    {
        return env('CDN_URL') . $this->icon_url;
    }
}
