<?php

namespace App\Services;

use Illuminate\Support\Facades\Storage;
use Aws\S3\S3Client;
use League\Flysystem\Filesystem;
use League\Flysystem\AwsS3V3\AwsS3V3Adapter;

class MinioService
{
    protected $filesystem;

    public function __construct()
    {
        $s3Client = new S3Client([
            'version' => 'latest',
            'region'  => env('MINIO_REGION'),
            'credentials' => [
                'key'    => env('MINIO_ACCESS_KEY'),
                'secret' => env('MINIO_SECRET_KEY'),
            ],
            'endpoint' => env('MINIO_ENDPOINT'),
            'use_path_style_endpoint' => true,
            'http' => [
                'verify' => false, 
            ],
        ]);
        
        $adapter = new AwsS3V3Adapter($s3Client, env('MINIO_BUCKET'));
        
        $this->filesystem = new Filesystem($adapter);
    }

    public function uploadFile($file, $path)
    {
        $contents = file_get_contents($file->getRealPath());
        $this->filesystem->write($path, $contents);
    }

    public function getFile($path)
    {
        return $this->filesystem->read($path);
    }
}
