<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('housing_areas', function (Blueprint $table) {
            $table->id();
            $table->string('area_id');
            $table->integer('geo_province_id');
            $table->integer('geo_town_id');
            $table->integer('geo_district_id');
            $table->integer('geo_village_id');
            $table->integer('program_label_id');
            $table->integer('budget_type_id');
            $table->integer('zone_type_id');
            $table->integer('bill_payment_method_id');
            $table->integer('extension_zone_type_id');
            $table->integer('bill_type_id');
            $table->string('book_number');
            $table->string('name');
            $table->string('postal_code');
            $table->tinyInteger('is_deleted')->nullable()->default(0);
            $table->timestamp('created_at')->default(\DB::raw('CURRENT_TIMESTAMP'));
            $table->timestamp('updated_at')->nullable();
            $table->timestamp('deleted_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::drop('housing_areas');
    }
};
