<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('registrations', function (Blueprint $table) {
            $table->id();
            $table->integer('kebutuhan_pelanggan');
            $table->integer('geo_province_id');
            $table->integer('geo_town_id');
            $table->integer('geo_district_id');
            $table->integer('geo_village_id');
            $table->integer('housing_area_id')->nullable();
            $table->string('nama_perumahan_jalan_utama', 255);
            $table->text('alamat');
            $table->string('rt', 3);
            $table->string('rw', 3);
            $table->string('kode_pos', 5);
            $table->integer('building_type_id');
            $table->string('nama_pemilik_bangunan', 255);
            $table->string('no_telpon_pemilik_bangunan', 20);
            $table->integer('status_lokasi_pemasangan');
            $table->text('latitude');
            $table->text('longitude');
            $table->integer('status_location_id');
            $table->string('nama', 255);
            $table->string('ktp', 20);
            $table->string('no_telpon', 20);
            $table->string('email', 255);
            $table->integer('electrical_power_id');
            $table->text('ktp_url');
            $table->text('rekening_listrik_url');
            $table->string('form_id', 255)->nullable()->default("");
            $table->text('ktp_url_relyon')->nullable()->default(null);
            $table->text('rekening_listrik_url_relyon')->nullable()->default(null);

            $table->tinyInteger('is_send')->nullable()->default(0);
            $table->timestamp('created_at')->default(\DB::raw('CURRENT_TIMESTAMP'));
            $table->timestamp('updated_at')->nullable();
            $table->timestamp('deleted_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::drop('registrations');
    }
};
