<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('kelengkapan_data', function (Blueprint $table) {
            $table->id();
            $table->string('customer_id');
            $table->string('nama_pelanggan');
            $table->integer('geo_province_id');
            $table->integer('geo_town_id');
            $table->integer('is_pk')->nullable();
            $table->integer('is_badan_hukum')->nullable();
            $table->integer('is_npwp')->nullable();
            $table->string('npwp', 20)->nullable();
            $table->string('ktp', 20)->nullable();
            $table->text('ktp_url')->nullable();
            $table->text('ktp_url_relyon')->nullable()->default(null);
            $table->string('nama_ktp', 255)->nullable();
            $table->text('alamat_ktp')->nullable();
            $table->text('alamat_lokasi_pemasangan')->nullable();
            $table->string('no_telpon', 20)->nullable();
            $table->string('email', 255)->nullable();
            $table->tinyInteger('is_send')->nullable()->default(0);
            $table->tinyInteger('is_send_email')->nullable()->default(0);

            $table->timestamp('created_at')->default(\DB::raw('CURRENT_TIMESTAMP'));
            $table->timestamp('updated_at')->nullable();
            $table->timestamp('deleted_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::drop('kelengkapan_data');
    }
};
