<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('areas', function (Blueprint $table) {
            $table->string('id', 3)->primary();
            $table->string('name');
            $table->string('manager_email')->nullable();
            $table->integer('lead_time_survey')->nullable();
            $table->integer('minimum_job_per_day')->default(0);
            $table->tinyInteger('is_deleted')->nullable()->default(0);

            $table->timestamp('created_at')->default(\DB::raw('CURRENT_TIMESTAMP'));
            $table->timestamp('updated_at')->nullable();
            $table->timestamp('deleted_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::drop('areas');
    }
};
