<?php

return [

    /*
    |---------------------------------------------------------------------------------------
    | Baris Bahasa untuk Validasi
    |---------------------------------------------------------------------------------------
    |
    | Baris bahasa berikut ini berisi standar pesan kesalahan yang digunakan oleh
    | kelas validasi. Beberapa aturan mempunyai multi versi seperti aturan 'size'.
    | Jangan ragu untuk mengoptimalkan setiap pesan yang ada di sini.
    |
    */

    "accepted"             => "Isian :attribute harus diterima.",
    "active_url"           => "Isian :attribute bukan URL yang valid.",
    "after"                => "Isian :attribute harus tanggal setelah :date.",
    "alpha"                => "Isian :attribute hanya boleh berisi huruf.",
    "alpha_dash"           => "Isian :attribute hanya boleh berisi huruf, angka, dan strip.",
    "alpha_num"            => "Isian :attribute hanya boleh berisi huruf dan angka.",
    "array"                => "Isian :attribute harus berupa sebuah array.",
    "before"               => "Isian :attribute harus tanggal sebelum :date.",
    "between"              => [
        "numeric" => "Isian :attribute harus antara :min dan :max.",
        "file"    => "Isian :attribute harus antara :min dan :max kilobytes.",
        "string"  => "Isian :attribute harus antara :min dan :max karakter.",
        "array"   => "Isian :attribute harus antara :min dan :max item.",
    ],
    "boolean"              => "Isian :attribute harus berupa true atau false",
    "confirmed"            => "Konfirmasi :attribute tidak cocok.",
    "date"                 => "Isian :attribute bukan tanggal yang valid.",
    "date_format"          => "Isian :attribute tidak cocok dengan format :format.",
    "different"            => "Isian :attribute dan :other harus berbeda.",
    "digits"               => "Isian :attribute harus berupa angka :digits.",
    "digits_between"       => "Isian :attribute harus antara angka :min dan :max.",
    "email"                => "Isian :attribute harus berupa alamat surel yang valid.",
    "exists"               => "Isian :attribute yang dipilih tidak valid.",
    "filled"               => ":attribute wajib diisi.",
    "image"                => "Isian :attribute harus berupa gambar.",
    "in"                   => "Isian :attribute yang dipilih tidak valid.",
    "integer"              => "Isian :attribute harus merupakan bilangan bulat.",
    "ip"                   => "Isian :attribute harus berupa alamat IP yang valid.",
    "max"                  => [
        "numeric" => "Isian :attribute seharusnya tidak lebih dari :max.",
        "file"    => "Isian :attribute seharusnya tidak lebih dari :max kilobytes.",
        "string"  => "Isian :attribute seharusnya tidak lebih dari :max karakter.",
        "array"   => "Isian :attribute seharusnya tidak lebih dari :max item.",
    ],
    "mimes"                => "Isian :attribute harus dokumen berjenis : :values.",
    "mimetypes"                => "Isian :attribute harus dokumen berjenis : :values.",
    "min"                  => [
        "numeric" => "Isian :attribute harus minimal :min.",
        "file"    => "Isian :attribute harus minimal :min kilobytes.",
        "string"  => "Isian :attribute harus minimal :min karakter.",
        "array"   => "Isian :attribute harus minimal :min item.",
    ],
    "not_in"               => "Isian :attribute yang dipilih tidak valid.",
    "numeric"              => "Isian :attribute tidak valid.",
    "regex"                => "Format isian :attribute tidak valid.",
    "required"             => ":attribute wajib diisi.",
    "required_if"          => ":attribute wajib diisi bila :other adalah :value.",
    "required_with"        => ":attribute wajib diisi bila terdapat :values.",
    "required_with_all"    => ":attribute wajib diisi bila terdapat :values.",
    "required_without"     => ":attribute wajib diisi bila tidak terdapat :values.",
    "required_without_all" => ":attribute wajib diisi bila tidak terdapat ada :values.",
    "same"                 => "Isian :attribute dan :other harus sama.",
    "size"                 => [
        "numeric" => "Isian :attribute harus berukuran :size.",
        "file"    => "Isian :attribute harus berukuran :size kilobyte.",
        "string"  => "Isian :attribute harus berukuran :size karakter.",
        "array"   => "Isian :attribute harus mengandung :size item.",
    ],
    "string"               => "The :attribute must be a string.",
    "timezone"             => "Isian :attribute harus berupa zona waktu yang valid.",
    "unique"               => "Isian :attribute sudah ada sebelumnya.",
    "url"                  => "Format isian :attribute tidak valid.",
    "not_found"            => "The :attribute is not found.",
    "json" => ":attribute bukan JSON yang valid",

    /*
    |---------------------------------------------------------------------------------------
    | Baris Bahasa untuk Validasi Kustom
    |---------------------------------------------------------------------------------------
    |
    | Di sini Anda dapat menentukan pesan validasi kustom untuk atribut dengan menggunakan
    | konvensi "attribute.rule" dalam penamaan baris. Hal ini membuat cepat dalam
    | menentukan spesifik baris bahasa kustom untuk aturan atribut yang diberikan.
    |
    */

    'custom' => [
        'kebutuhan_pelanggan' => [
        ],
        'lokasi_pemasangan_provinsi' => [
            'required' => 'Isian Provinsi pada form Lokasi Pemasangan harus diisi',
            'numeric' => 'Isian Provinsi pada form Lokasi Pemasangan tidak valid',
            'exists' => 'Isian Provinsi pada form Lokasi Pemasangan tidak valid'
        ],
        'lokasi_pemasangan_kota' => [
            'required' => 'Isian Kota/Kabupatan pada form Lokasi Pemasangan harus diisi',
            'numeric' => 'Isian Kota/Kabupatan pada form Lokasi Pemasangan tidak valid',
            'exists' => 'Isian Kota/Kabupatan pada form Lokasi Pemasangan tidak valid'
        ],
        'lokasi_pemasangan_kecamatan' => [
            'required' => 'Isian Kecamatan pada form Lokasi Pemasangan harus diisi',
            'numeric' => 'Isian Kecamatan pada form Lokasi Pemasangan tidak valid',
            'exists' => 'Isian Kecamatan pada form Lokasi Pemasangan tidak valid'
        ],
        'lokasi_pemasangan_kelurahan' => [
            'required' => 'Isian Kelurahan pada form Lokasi Pemasangan harus diisi',
            'numeric' => 'Isian Kelurahan pada form Lokasi Pemasangan tidak valid',
            'exists' => 'Isian Kelurahan pada form Lokasi Pemasangan tidak valid'
        ],
        'lokasi_pemasangan_perumahan_jalan_utama' => [
            'required' => 'Isian Perumahan Jalan Utama pada form Lokasi Pemasangan harus diisi',
            'numeric' => 'Isian Perumahan Jalan Utama pada form Lokasi Pemasangan tidak valid',
            'exists' => 'Isian Perumahan Jalan Utama pada form Lokasi Pemasangan tidak valid'
        ],
        'lokasi_pemasangan_nama_perumahan_jalan_utama' => [
            'required' => 'Isian Nama Perumahan Jalan Utama pada form Lokasi Pemasangan harus diisi',
            'regex' => 'Isian Nama Perumahan Jalan Utama pada form Lokasi Pemasangan terdapat karakter tidak valid'
        ],
        'lokasi_pemasangan_alamat' => [
            'required' => 'Isian Alamat Lengkap pada form Lokasi Pemasangan harus diisi',
            'regex' => 'Isian Alamat Lengkap pada form Lokasi Pemasangan terdapat karakter tidak valid'
        ],
        'lokasi_pemasangan_rt' => [
            'required' => 'Isian RT pada form Lokasi Pemasangan harus diisi',
            'regex' => 'Isian RT pada form Lokasi Pemasangan terdapat karakter tidak valid',
            'max' => [
                "numeric" => "Isian RT pada form Lokasi Pemasangan seharusnya tidak lebih dari :max.",
                "string"  => "Isian RT pada form Lokasi Pemasangan seharusnya tidak lebih dari :max karakter.",
                "regex"   => "Isian RT pada form Lokasi Pemasangan seharusnya tidak lebih dari :max karakter.",
            ]
        ],
        'lokasi_pemasangan_rw' => [
            'required' => 'Isian RW pada form Lokasi Pemasangan harus diisi',
            'regex' => 'Isian RW pada form Lokasi Pemasangan terdapat karakter tidak valid',
            'max' => [
                "numeric" => "Isian RW pada form Lokasi Pemasangan seharusnya tidak lebih dari :max.",
                "string"  => "Isian RW pada form Lokasi Pemasangan seharusnya tidak lebih dari :max karakter.",
                "regex"   => "Isian RW pada form Lokasi Pemasangan seharusnya tidak lebih dari :max karakter.",
            ]
        ],
        'lokasi_pemasangan_kode_pos' => [
            'required' => 'Isian Kode Pos pada form Lokasi Pemasangan harus diisi',
            'regex' => 'Isian Kode Pos pada form Lokasi Pemasangan terdapat karakter tidak valid',
            'max' => [
                "numeric" => "Isian Kode Pos pada form Lokasi Pemasangan seharusnya tidak lebih dari :max.",
                "string"  => "Isian Kode Pos pada form Lokasi Pemasangan seharusnya tidak lebih dari :max karakter.",
                "regex"   => "Isian Kode Pos pada form Lokasi Pemasangan seharusnya tidak lebih dari :max karakter.",
            ]
        ],
        'lokasi_pemasangan_jenis_bangunan' => [
            'required' => 'Isian Jenis Bangunan pada form Lokasi Pemasangan harus diisi',
            'numeric' => 'Isian Jenis Bangunan pada form Lokasi Pemasangan tidak valid',
            'exists' => 'Isian Jenis Bangunan pada form Lokasi Pemasangan tidak valid'
        ],
        'lokasi_pemasangan_nama_pemilik_bangunan' => [
            'required' => 'Isian Nama Pemilik Bangunan pada form Lokasi Pemasangan harus diisi',
            'regex' => 'Isian Nama Pemilik Bangunan pada form Lokasi Pemasangan terdapat karakter tidak valid'
        ],
        'lokasi_pemasangan_no_telpon' => [
            'required' => 'Isian No Telepon pada form Lokasi Pemasangan harus diisi',
            'regex' => 'Isian No Telepon pada form Lokasi Pemasangan terdapat karakter tidak valid',
            'max' => [
                "numeric" => "Isian No Telepon pada form Lokasi Pemasangan seharusnya tidak lebih dari :max.",
                "string"  => "Isian No Telepon pada form Lokasi Pemasangan seharusnya tidak lebih dari :max karakter.",
                "regex"   => "Isian No Telepon pada form Lokasi Pemasangan seharusnya tidak lebih dari :max karakter.",
            ],
            'min' => [
                "numeric" => "Isian No Telepon pada form Lokasi Pemasangan harus minimal :min.",
                "string"  => "Isian No Telepon pada form Lokasi Pemasangan harus minimal :min karakter.",
                "regex"   => "Isian No Telepon pada form Lokasi Pemasangan harus minimal :min karakter.",
            ]
        ],
        'lokasi_pemasangan_status_kepemilikan' => [
            'required' => 'Isian Status Kepemilikan pada form Lokasi Pemasangan harus diisi',
            'numeric' => 'Isian Status Kepemilikan pada form Lokasi Pemasangan tidak valid',
            'exists' => 'Isian Status Kepemilikan pada form Lokasi Pemasangan tidak valid'
        ],
        'lokasi_pemasangan_status_lokasi_pemasangan' => [
            'required' => 'Isian Status Lokasi Pemasangan pada form Lokasi Pemasangan harus diisi',
            'regex' => 'Isian Status Lokasi Pemasangan pada form Lokasi Pemasangan terdapat karakter tidak valid',
            'in' => 'Isian Status Lokasi Pemasangan pada form Lokasi Pemasangan tidak valid'
        ],

        'penggunaan_nama' => [
            'required' => 'Isian Nama pada form Identitas Pelanggan harus diisi',
            'regex' => 'Isian Nama pada form Identitas Pelanggan terdapat karakter tidak valid'
        ],
        'penggunaan_ktp' => [
            'required' => 'Isian Nomor Kartu Tanda Penduduk pada form Identitas Pelanggan harus diisi',
            'regex' => 'Isian Nomor Kartu Tanda Penduduk pada form Identitas Pelanggan terdapat karakter tidak valid',
            'max' => [
                "numeric" => "Isian Nomor Kartu Tanda Penduduk pada form Identitas Pelanggan Pemasangan seharusnya tidak lebih dari :max.",
                "string"  => "Isian Nomor Kartu Tanda Penduduk pada form Identitas Pelanggan seharusnya tidak lebih dari :max karakter.",
                "regex"   => "Isian Nomor Kartu Tanda Penduduk pada form Identitas Pelanggan seharusnya tidak lebih dari :max karakter.",
            ],
            'min' => [
                "numeric" => "Isian Nomor Kartu Tanda Penduduk pada form Identitas Pelanggan harus minimal :min.",
                "string"  => "Isian Nomor Kartu Tanda Penduduk pada form Identitas Pelanggan harus minimal :min karakter.",
                "regex"   => "Isian Nomor Kartu Tanda Penduduk pada form Identitas Pelanggan harus minimal :min karakter.",
            ]
        ],
        'penggunaan_no_telpon' => [
            'required' => 'Isian No Telepon pada form Identitas Pelanggan harus diisi',
            'regex' => 'Isian No Telepon pada form Identitas Pelanggan terdapat karakter tidak valid',
            'max' => [
                "numeric" => "Isian No Telepon pada form Identitas Pelanggan Pemasangan seharusnya tidak lebih dari :max.",
                "string"  => "Isian No Telepon pada form Identitas Pelanggan seharusnya tidak lebih dari :max karakter.",
                "regex"   => "Isian No Telepon pada form Identitas Pelanggan seharusnya tidak lebih dari :max karakter.",
            ],
            'min' => [
                "numeric" => "Isian No Telepon pada form Identitas Pelanggan harus minimal :min.",
                "string"  => "Isian No Telepon pada form Identitas Pelanggan harus minimal :min karakter.",
                "regex"   => "Isian No Telepon pada form Identitas Pelanggan harus minimal :min karakter.",
            ]
        ],
        'penggunaan_email' => [
            'required' => 'Isian Email pada form Identitas Pelanggan harus diisi',
            "email" => "Isian Email pada form Identitas Pelanggan harus berupa alamat surel yang valid.",
        ],
        'penggunaan_energi_listrik' => [
            'required' => 'Isian Energi Listrik pada form Penggunaan harus diisi',
            'numeric' => 'Isian Energi Listrik pada form Penggunaan tidak valid',
            'exists' => 'Isian Energi Listrik pada form Penggunaan tidak valid'
        ],
        'penggunaan_bahan_bakar' => [
            'required' => 'Isian Bahan Bakar pada form Penggunaan harus diisi',
            'array' => 'Isian Bahan Bakar pada form Penggunaan harus berupa sebuah array'
        ],
        'penggunaan_bahan_bakar.*.id' => [
            'numeric' => 'Isian Bahan Bakar pada form Penggunaan tidak valid',
            'exists' => 'Isian Bahan Bakar pada form Penggunaan tidak valid'
        ],
        'penggunaan_bahan_bakar.*.value' => [
            'numeric' => 'Isian Bahan Bakar pada form Penggunaan tidak valid',
            'exists' => 'Isian Bahan Bakar pada form Penggunaan tidak valid',
            'max' => [
                "numeric" => "Isian Bahan Bakar pada form Penggunaan seharusnya tidak lebih dari :max."
            ],
            'min' => [
                "numeric" => "Isian Bahan Bakar pada form Penggunaan harus minimal :min."
            ]
        ],
        'penggunaan_peralatan' => [
            'required' => 'Isian Peralatan Gas pada form Penggunaan harus diisi',
            'required_if' => 'Isian Peralatan Gas pada form Penggunaan wajib diisi bila Kebutuhan Pelanggan adalah Kebutuhan Komersial/Jasa (tempat makan, laundry, perkantoran dan lainnya).',
            'array' => 'Isian Peralatan Gas pada form Penggunaan harus berupa sebuah array'
        ],
        'penggunaan_peralatan.*.id' => [
            'numeric' => 'Isian Peralatan Gas pada form Penggunaan tidak valid',
            'exists' => 'Isian Peralatan Gas pada form Penggunaan tidak valid'
        ],
        'penggunaan_peralatan.*.value' => [
            'numeric' => 'Isian Peralatan Gas pada form Penggunaan tidak valid',
            'exists' => 'Isian Peralatan Gas pada form Penggunaan tidak valid',
            'max' => [
                "numeric" => "Isian Peralatan Gas pada form Penggunaan seharusnya tidak lebih dari :max."
            ],
            'min' => [
                "numeric" => "Isian Peralatan Gas pada form Penggunaan harus minimal :min."
            ]
        ],
        'penggunaan_ktp_file' => [
            'image' => 'Isian File KTP pada form Penggunaan harus berupa gambar',
            'mimes' => 'Isian File KTP pada form Penggunaan harus dokumen berjenis : :values.',
            'max' => [
                "file" => "Isian File KTP pada form Penggunaan seharusnya tidak lebih dari :max kilobytes."
            ]
        ],

        // BACKOFFICE
        'user_name' => [
            'required' => 'Isian User Name harus diisi',
            'regex' => 'Isian User Name terdapat karakter tidak valid'
        ],
        'email' => [
            'required' => 'Isian Email harus diisi',
            'email' => 'Isian Email tidak valid'
        ],
        'is_active' => [
            'required' => 'Isian Is Actice harus diisi',
            'numeric' => 'Isian Is Actice tidak valid',
            'in' => 'Isian Is Actice tidak valid'
        ],
        'konten' => [
            'required' => 'Isian Konten harus diisi',
            'regex' => 'Isian Konten tidak valid'
        ],
        'old_password' => [
            'required' => 'Isian Old Passwors harus diisi',
            'regex' => 'Isian Old Passwors tidak valid'
        ],
        'new_password' => [
            'required' => 'Isian New Passwors harus diisi',
            'regex' => 'Isian New Passwors tidak valid'
        ],
        'confirm_password' => [
            'required' => 'Isian Confirm Passwors harus diisi',
            'regex' => 'Isian Confirm Passwors tidak valid'
        ],
        'area_id' => [
            'required' => 'Isian Area harus diisi',
            'numeric' => 'Isian Area tidak valid',
            'exists' => 'Isian Area tidak valid'
        ],
    ],


    /*
    |---------------------------------------------------------------------------------------
    | Kustom Validasi Atribut
    |---------------------------------------------------------------------------------------
    |
    | Baris bahasa berikut digunakan untuk menukar atribut 'place-holders'
    | dengan sesuatu yang lebih bersahabat dengan pembaca seperti Alamat Surel daripada
    | "surel" saja. Ini benar-benar membantu kita membuat pesan sedikit bersih.
    |
    */

    'attributes' => [
    ],

];