<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

// REGISTER
use App\Http\Controllers\GeoController;
use App\Http\Controllers\ToolsController;
use App\Http\Controllers\RegistrationCapelController;
use App\Http\Controllers\KontenController;

// KELENGKAPAN DATA
use App\Http\Controllers\KelengkapanData\KelengkapanDataController;

// BACKOFFICE
use App\Http\Controllers\AuthController;
use App\Http\Controllers\Registration\RegistrationController;
use App\Http\Controllers\Users\UsersController;
use App\Http\Controllers\Brosur\BrosurController;
use App\Http\Controllers\FilePernyataan\FilePernyataanController;
use App\Http\Controllers\KebenaranData\KebenaranDataController;
use App\Http\Controllers\KetentuanUmum\KetentuanUmumController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware(['customToken'])->group(function () {
    
    // REGISTER
    Route::prefix('geo')->group(function () {
        Route::get('province', [GeoController::class, 'getProvince']);
        Route::get('town', [GeoController::class, 'getTown']);
        Route::get('district', [GeoController::class, 'getDistrict']);
        Route::get('village', [GeoController::class, 'getVillage']);
        Route::get('housing_area', [GeoController::class, 'getHousingArea']);
        Route::get('building_type', [GeoController::class, 'getBuildingType']);
        Route::get('status_location', [GeoController::class, 'getStatusLocation']);
    });

    Route::prefix('tools')->group(function () {
        Route::get('gas_tools', [ToolsController::class, 'getGasTools']);
        Route::get('fuels', [ToolsController::class, 'getFuels']);
        Route::get('electrical_power', [ToolsController::class, 'getElectricalPower']);
    });

    Route::post('/register', [RegistrationCapelController::class, 'postRegister']);
    Route::post('/check_duplicate_data', [RegistrationCapelController::class, 'checkDuplicateData']);
    
    Route::get('/konten', [KontenController::class, 'index']);

    // KELENGKAPAN DATA
    Route::prefix('kelengkapan-data')->group(function () {
        Route::post('/verifikasi-id', [KelengkapanDataController::class, 'verifikasiId']);
        Route::post('/update', [KelengkapanDataController::class, 'update']);
    });

});

// BACKOFFICE
Route::post('/login', [AuthController::class, 'login'])->name('api.login');;

Route::middleware('auth:sanctum')->group(function () {
    Route::post('/logout', [AuthController::class, 'logout'])->name('api.logout');

    Route::get('/me', [AuthController::class, 'me'])->name('api.me');

    Route::prefix('registration/log')->group(function () {
        Route::get('/', [RegistrationController::class, 'indexLog']);
        Route::get('/export', [RegistrationController::class, 'exportRegisterLog']);
        Route::post('/sync', [RegistrationController::class, 'syncRegisterLog']);
    });

    Route::prefix('kelengkapan-data/log')->group(function () {
        Route::get('/', [KelengkapanDataController::class, 'indexLog']);
        Route::get('/export', [KelengkapanDataController::class, 'exportLog']);
        Route::post('/sync', [KelengkapanDataController::class, 'syncLog']);
    });

    Route::prefix('registration/report')->group(function () {
        Route::get('/', [RegistrationController::class, 'indexReport']);
        Route::get('/export', [RegistrationController::class, 'exportRegisterReport']);
        Route::post('/send-email', [RegistrationController::class, 'sendEmailRegisterReport']);
        Route::get('/area', [RegistrationController::class, 'getArea']);
    });

    Route::prefix('registration')->group(function () {
        Route::get('/', [RegistrationController::class, 'index']);
        Route::get('/export', [RegistrationController::class, 'exportRegister']);
        Route::get('/{id}', [RegistrationController::class, 'detail']);
    });

    Route::prefix('user')->group(function () {
        Route::get('/', [UsersController::class, 'index']);
        Route::get('/{id}', [UsersController::class, 'detail']);
        Route::post('/', [UsersController::class, 'store']);
        Route::put('/', [UsersController::class, 'update']);
        Route::post('/delete', [UsersController::class, 'destroy']);
        Route::post('/change-password', [UsersController::class, 'changePassword']);
    });

    Route::prefix('brosur')->group(function () {
        Route::get('/', [BrosurController::class, 'index']);
        Route::post('/upload', [BrosurController::class, 'uploadFile']);
    });

    Route::prefix('file-pernyataan')->group(function () {
        Route::get('/', [FilePernyataanController::class, 'index']);
        Route::post('/upload', [FilePernyataanController::class, 'uploadFile']);
    });

    Route::prefix('kebenaran-data')->group(function () {
        Route::get('/', [KebenaranDataController::class, 'index']);
        Route::post('/', [KebenaranDataController::class, 'update']);
    });

    Route::prefix('ketentuan-umum')->group(function () {
        Route::get('/', [KetentuanUmumController::class, 'index']);
        Route::post('/', [KetentuanUmumController::class, 'update']);
    });

});
