'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var reactDom = require('react-dom');
var index_cjs = require('@fullcalendar/core/index.cjs');
var internal_cjs = require('@fullcalendar/core/internal.cjs');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

/* eslint-disable @typescript-eslint/no-explicit-any */
class FullCalendar extends React.Component {
    constructor() {
        super(...arguments);
        this.elRef = React.createRef();
        this.needsCustomRenderingResize = false;
        this.isInitialRender = true;
        this.state = {
            customRenderingMap: new Map()
        };
    }
    render() {
        const portalNodes = [];
        for (const customRendering of this.state.customRenderingMap.values()) {
            const { generatorMeta } = customRendering;
            const vnode = typeof generatorMeta === 'function' ?
                generatorMeta(customRendering.renderProps) :
                generatorMeta;
            portalNodes.push(reactDom.createPortal(vnode, customRendering.containerEl, customRendering.id));
        }
        return (React__default["default"].createElement("div", { ref: this.elRef }, portalNodes));
    }
    componentDidMount() {
        const customRenderingStore = new internal_cjs.CustomRenderingStore();
        this.handleCustomRendering = customRenderingStore.handle.bind(customRenderingStore);
        this.calendar = new index_cjs.Calendar(this.elRef.current, Object.assign(Object.assign({}, this.props), { handleCustomRendering: this.handleCustomRendering }));
        this.calendar.render();
        customRenderingStore.subscribe((customRenderingMap) => {
            if (this.isInitialRender) {
                this.doCustomRendering(customRenderingMap);
            }
            else {
                this.requestCustomRendering(customRenderingMap);
            }
        });
    }
    requestCustomRendering(customRenderingMap) {
        this.cancelCustomRendering();
        this.customRenderingRequestId = requestAnimationFrame(() => {
            FullCalendar.act(() => {
                this.doCustomRendering(customRenderingMap);
            });
        });
    }
    doCustomRendering(customRenderingMap) {
        this.needsCustomRenderingResize = true;
        this.setState({ customRenderingMap });
    }
    cancelCustomRendering() {
        if (this.customRenderingRequestId) {
            cancelAnimationFrame(this.customRenderingRequestId);
            this.customRenderingRequestId = undefined;
        }
    }
    componentDidUpdate() {
        this.isInitialRender = false;
        this.calendar.resetOptions(Object.assign(Object.assign({}, this.props), { handleCustomRendering: this.handleCustomRendering }));
        if (this.needsCustomRenderingResize) {
            this.needsCustomRenderingResize = false;
            this.calendar.updateSize();
        }
    }
    componentWillUnmount() {
        this.calendar.destroy();
        this.cancelCustomRendering();
    }
    getApi() {
        return this.calendar;
    }
}
FullCalendar.act = (f) => { f(); };

exports["default"] = FullCalendar;
