/* eslint-disable @typescript-eslint/no-explicit-any */
import React, { Component, createRef } from 'react';
import { createPortal } from 'react-dom';
import { Calendar, } from '@fullcalendar/core';
import { CustomRenderingStore, } from '@fullcalendar/core/internal';
export default class FullCalendar extends Component {
    constructor() {
        super(...arguments);
        this.elRef = createRef();
        this.needsCustomRenderingResize = false;
        this.isInitialRender = true;
        this.state = {
            customRenderingMap: new Map()
        };
    }
    render() {
        const portalNodes = [];
        for (const customRendering of this.state.customRenderingMap.values()) {
            const { generatorMeta } = customRendering;
            const vnode = typeof generatorMeta === 'function' ?
                generatorMeta(customRendering.renderProps) :
                generatorMeta;
            portalNodes.push(createPortal(vnode, customRendering.containerEl, customRendering.id));
        }
        return (React.createElement("div", { ref: this.elRef }, portalNodes));
    }
    componentDidMount() {
        const customRenderingStore = new CustomRenderingStore();
        this.handleCustomRendering = customRenderingStore.handle.bind(customRenderingStore);
        this.calendar = new Calendar(this.elRef.current, Object.assign(Object.assign({}, this.props), { handleCustomRendering: this.handleCustomRendering }));
        this.calendar.render();
        customRenderingStore.subscribe((customRenderingMap) => {
            if (this.isInitialRender) {
                this.doCustomRendering(customRenderingMap);
            }
            else {
                this.requestCustomRendering(customRenderingMap);
            }
        });
    }
    requestCustomRendering(customRenderingMap) {
        this.cancelCustomRendering();
        this.customRenderingRequestId = requestAnimationFrame(() => {
            FullCalendar.act(() => {
                this.doCustomRendering(customRenderingMap);
            });
        });
    }
    doCustomRendering(customRenderingMap) {
        this.needsCustomRenderingResize = true;
        this.setState({ customRenderingMap });
    }
    cancelCustomRendering() {
        if (this.customRenderingRequestId) {
            cancelAnimationFrame(this.customRenderingRequestId);
            this.customRenderingRequestId = undefined;
        }
    }
    componentDidUpdate() {
        this.isInitialRender = false;
        this.calendar.resetOptions(Object.assign(Object.assign({}, this.props), { handleCustomRendering: this.handleCustomRendering }));
        if (this.needsCustomRenderingResize) {
            this.needsCustomRenderingResize = false;
            this.calendar.updateSize();
        }
    }
    componentWillUnmount() {
        this.calendar.destroy();
        this.cancelCustomRendering();
    }
    getApi() {
        return this.calendar;
    }
}
FullCalendar.act = (f) => { f(); };
//# sourceMappingURL=index.js.map