'use strict';

const fs = require('fs');
const iconSet_index = require('../icon-set/index.cjs');
const misc_keyword = require('../misc/keyword.cjs');
const misc_scan = require('../misc/scan.cjs');
const svg_index = require('../svg/index.cjs');
const svg_cleanup = require('../svg/cleanup.cjs');
require('@iconify/utils/lib/icon/defaults');
require('@iconify/utils/lib/svg/build');
require('@iconify/utils/lib/icon-set/minify');
require('@iconify/utils/lib/icon-set/convert-info');
require('../icon-set/props.cjs');
require('@iconify/utils/lib/misc/objects');
require('@iconify/utils');
require('cheerio');
require('../svg/cleanup/attribs.cjs');
require('../svg/data/attributes.cjs');
require('../svg/data/tags.cjs');
require('../svg/parse.cjs');
require('../svg/cleanup/bad-tags.cjs');
require('../svg/cleanup/inline-style.cjs');
require('../css/parse.cjs');
require('../css/parser/tokens.cjs');
require('../css/parser/error.cjs');
require('../css/parser/strings.cjs');
require('../css/parser/text.cjs');
require('../svg/cleanup/root-style.cjs');
require('../svg/parse-style.cjs');
require('../css/parser/export.cjs');
require('../css/parser/tree.cjs');
require('../svg/cleanup/root-svg.cjs');
require('../svg/cleanup/svgo-style.cjs');
require('../optimise/svgo.cjs');
require('svgo');
require('@iconify/utils/lib/svg/id');

async function importDirectory(path, options = {}) {
  const files = await misc_scan.scanDirectory(path, (ext, file, subdir, path2) => {
    if (ext.toLowerCase() === ".svg") {
      const result = {
        file,
        ext,
        subdir,
        path: path2
      };
      return result;
    }
    return false;
  });
  const iconSet = iconSet_index.blankIconSet(options.prefix || "");
  for (let i = 0; i < files.length; i++) {
    const file = files[i];
    const defaultKeyword = misc_keyword.cleanupIconKeyword(file.file);
    let keyword = options.keyword ? options.keyword(file, defaultKeyword, iconSet) : defaultKeyword;
    if (keyword instanceof Promise) {
      keyword = await keyword;
    }
    if (typeof keyword !== "string" || !keyword.length) {
      continue;
    }
    try {
      const content = await fs.promises.readFile(
        file.path + file.subdir + file.file + file.ext,
        "utf8"
      );
      const svg = new svg_index.SVG(content);
      await svg_cleanup.cleanupSVG(svg);
      iconSet.fromSVG(keyword, svg);
    } catch (err) {
      if (options.ignoreImportErrors !== false) {
        throw err;
      }
    }
  }
  return iconSet;
}

exports.importDirectory = importDirectory;
