import { IconSet } from '../icon-set/index.js';
import '@iconify/types';
import '@iconify/utils/lib/customisations/defaults';
import '../icon-set/types.js';
import '../svg/index.js';
import '@iconify/utils/lib/icon-set/tree';

/**
 * Entry for file
 */
interface ImportDirectoryFileEntry {
    path: string;
    subdir: string;
    file: string;
    ext: string;
}
/**
 * Callback to get keyword for icon based on file name
 *
 * Returns:
 * - string for new keyword
 * - undefined to skip icon
 *
 * Callback can be asynchronous
 */
type ImportDirectoryKeywordCallbackResult = string | undefined;
type ImportDirectoryKeywordCallback = (file: ImportDirectoryFileEntry, defaultKeyword: string, iconSet: IconSet) => ImportDirectoryKeywordCallbackResult | Promise<ImportDirectoryKeywordCallbackResult>;
/**
 * Options
 */
interface ImportDirectoryOptions {
    prefix?: string;
    includeSubDirs?: boolean;
    keyword?: ImportDirectoryKeywordCallback;
    ignoreImportErrors?: boolean;
}
/**
 * Import all icons from directory
 */
declare function importDirectory(path: string, options?: ImportDirectoryOptions): Promise<IconSet>;

export { ImportDirectoryFileEntry, ImportDirectoryKeywordCallback, importDirectory };
