import { Stats } from 'fs';

/**
 * Callback
 *
 * Extension starts with '.' (can be empty)
 * File does not include extension
 * Subdir ends with '/' (can be empty)
 *
 * Should return:
 * - false, null or undefined to skip file
 * - true to include file (subdir + file + extension)
 * - string to include custom string (such as file without extension)
 * - custom object to return custom object
 */
type ScanDirectoryCallbackFalseResult = boolean | null | undefined;
type ScanDirectoryCallbackStringResult = ScanDirectoryCallbackFalseResult | string;
type ScanDirectoryCallbackAsString = (ext: string, file: string, subdir: string, path: string, stat: Stats) => ScanDirectoryCallbackStringResult | Promise<ScanDirectoryCallbackStringResult>;
type ScanDirectoryCallbackAsCustom<T> = (ext: string, file: string, subdir: string, path: string, stat: Stats) => T | ScanDirectoryCallbackFalseResult | Promise<T | ScanDirectoryCallbackFalseResult>;
type ScanDirectoryCallback = ScanDirectoryCallbackAsCustom<unknown> | ScanDirectoryCallbackAsString;
/**
 * Find all files in directory
 */
declare function scanDirectory(path: string, callback?: ScanDirectoryCallbackAsString, subdirs?: boolean): Promise<string[]>;
declare function scanDirectory<T>(path: string, callback: ScanDirectoryCallbackAsCustom<T>, subdirs?: boolean): Promise<T[]>;

export { ScanDirectoryCallback, scanDirectory };
