import { parseSVGStyle } from '../parse-style.mjs';
import '../../css/parse.mjs';
import '../../css/parser/tokens.mjs';
import '../../css/parser/error.mjs';
import '../../css/parser/strings.mjs';
import '../../css/parser/text.mjs';
import '../../css/parser/export.mjs';
import '../../css/parser/tree.mjs';
import '../parse.mjs';

function cleanupRootStyle(svg) {
  return parseSVGStyle(svg, (item) => {
    if (
      // If global style
      item.type === "global" && // If selector tokens contain at-rule
      item.selectorTokens.find((token) => token.type === "at-rule")
    ) {
      return;
    }
    return item.value;
  });
}

export { cleanupRootStyle };
