async function parseSVG(svg, callback) {
  async function checkNode(element, parents) {
    if (element.type !== "tag") {
      return;
    }
    const $element = cheerio(element);
    const tagName = element.tagName;
    const item = {
      tagName,
      element,
      $element,
      svg,
      parents,
      testChildren: true,
      removeNode: false
    };
    const result = callback(item);
    if (result instanceof Promise) {
      await result;
    }
    const newParents = parents.slice(0);
    newParents.unshift(item);
    if (tagName !== "style" && item.testChildren && !item.removeNode) {
      const children = $element.children().toArray();
      for (let i = 0; i < children.length; i++) {
        await checkNode(children[i], newParents);
      }
    }
    if (item.removeNode) {
      $element.remove();
    }
  }
  const cheerio = svg.$svg;
  const $root = svg.$svg(":root");
  await checkNode($root.get(0), []);
}

export { parseSVG };
