import * as React from 'react';
import { GridStateColDef } from '../../models/colDef/gridColDef';
import { GridSortDirection } from '../../models/gridSortModel';
import { GridColumnHeaderSeparatorProps } from './GridColumnHeaderSeparator';
import { GridColumnGroup } from '../../models/gridColumnGrouping';
interface GridGenericColumnHeaderItemProps extends Pick<GridStateColDef, 'headerClassName' | 'description' | 'resizable'> {
    classes: Record<'root' | 'draggableContainer' | 'titleContainer' | 'titleContainerContent', string>;
    colIndex: number;
    columnMenuOpen: boolean;
    height: number;
    isResizing: boolean;
    sortDirection: GridSortDirection;
    sortIndex?: number;
    filterItemsCounter?: number;
    hasFocus?: boolean;
    tabIndex: 0 | -1;
    disableReorder?: boolean;
    separatorSide?: GridColumnHeaderSeparatorProps['side'];
    headerComponent?: React.ReactNode;
    elementId: GridStateColDef['field'] | GridColumnGroup['groupId'];
    isDraggable: boolean;
    width: number;
    columnMenuIconButton?: React.ReactNode;
    columnMenu?: React.ReactNode;
    columnTitleIconButtons?: React.ReactNode;
    label: string;
    draggableContainerProps?: Partial<React.HTMLProps<HTMLDivElement>>;
    columnHeaderSeparatorProps?: Partial<GridColumnHeaderSeparatorProps>;
}
declare const GridGenericColumnHeaderItem: React.ForwardRefExoticComponent<GridGenericColumnHeaderItemProps & React.RefAttributes<unknown>>;
export { GridGenericColumnHeaderItem };
