import type { GridRowId } from '../../../models';
import { GridColDef, GridStateColDef } from '../../../models/colDef/gridColDef';
import type { GridColumnDimensionProperties } from './gridColumnsUtils';
export type GridColumnLookup = {
    [field: string]: GridStateColDef;
};
export type GridColumnRawLookup = {
    [field: string]: GridColDef | GridStateColDef;
};
export interface GridColumnsState {
    orderedFields: string[];
    lookup: GridColumnLookup;
    columnVisibilityModel: GridColumnVisibilityModel;
}
export type GridColumnDimensions = {
    [key in GridColumnDimensionProperties]?: number;
};
export interface GridColumnsInitialState {
    columnVisibilityModel?: GridColumnVisibilityModel;
    orderedFields?: string[];
    dimensions?: Record<string, GridColumnDimensions>;
}
export type GridColumnsRawState = Omit<GridColumnsState, 'lookup'> & {
    lookup: GridColumnRawLookup;
};
export type GridHydrateColumnsValue = GridColumnsRawState;
export type GridColumnVisibilityModel = Record<GridRowId, boolean>;
