import * as React from 'react';
import { useFirstRender } from '../../utils/useFirstRender';
export var useGridRegisterPipeProcessor = function useGridRegisterPipeProcessor(apiRef, group, callback) {
  var cleanup = React.useRef();
  var id = React.useRef("mui-".concat(Math.round(Math.random() * 1e9)));
  var registerPreProcessor = React.useCallback(function () {
    cleanup.current = apiRef.current.registerPipeProcessor(group, id.current, callback);
  }, [apiRef, callback, group]);
  useFirstRender(function () {
    registerPreProcessor();
  });
  var isFirstRender = React.useRef(true);
  React.useEffect(function () {
    if (isFirstRender.current) {
      isFirstRender.current = false;
    } else {
      registerPreProcessor();
    }
    return function () {
      if (cleanup.current) {
        cleanup.current();
        cleanup.current = null;
      }
    };
  }, [registerPreProcessor]);
};