export { renderToReadableStream, decodeReply, decodeAction, decodeFormState } from "react-server-dom-webpack/server.edge";
import AppRouter from "../../client/components/app-router";
import LayoutRouter from "../../client/components/layout-router";
import RenderFromTemplateContext from "../../client/components/render-from-template-context";
import { staticGenerationAsyncStorage } from "../../client/components/static-generation-async-storage.external";
import { requestAsyncStorage } from "../../client/components/request-async-storage.external";
import { actionAsyncStorage } from "../../client/components/action-async-storage.external";
import { staticGenerationBailout } from "../../client/components/static-generation-bailout";
import StaticGenerationSearchParamsBailoutProvider from "../../client/components/static-generation-searchparams-bailout-provider";
import { createSearchParamsBailoutProxy } from "../../client/components/searchparams-bailout-proxy";
import * as serverHooks from "../../client/components/hooks-server-context";
import { patchFetch as _patchFetch } from "../lib/patch-fetch";
import { preloadStyle, preloadFont, preconnect } from "../../server/app-render/rsc/preloads";
import { taintObjectReference } from "../../server/app-render/rsc/taint";
const { NotFoundBoundary } = require("next/dist/client/components/not-found-boundary");
// patchFetch makes use of APIs such as `React.unstable_postpone` which are only available
// in the experimental channel of React, so export it from here so that it comes from the bundled runtime
function patchFetch() {
    return _patchFetch({
        serverHooks,
        staticGenerationAsyncStorage
    });
}
export { AppRouter, LayoutRouter, RenderFromTemplateContext, staticGenerationAsyncStorage, requestAsyncStorage, actionAsyncStorage, staticGenerationBailout, createSearchParamsBailoutProxy, serverHooks, preloadStyle, preloadFont, preconnect, taintObjectReference, StaticGenerationSearchParamsBailoutProvider, NotFoundBoundary, patchFetch,  };

//# sourceMappingURL=entry-base.js.map