// ** Next Import
import { useState, useEffect } from 'react'
import { useRouter } from 'next/router'
import { useTheme } from '@mui/material/styles'

// ** MUI Imports
import Grid from '@mui/material/Grid'
import Card from '@mui/material/Card'
import CardHeader from '@mui/material/CardHeader'
import CustomTextField from 'src/@core/components/mui/text-field'
import CardContent from '@mui/material/CardContent'
import toast from 'react-hot-toast'
import Button from '@mui/material/Button'
import CardActions from '@mui/material/CardActions'
import CircularProgress from '@mui/material/CircularProgress'
import btoa from 'btoa'

import Divider from '@mui/material/Divider'

// PGN
import { endPoint } from 'src/service/constans'
import { callPost } from 'src/service/api'

const UserCreate = () => {
  const theme = useTheme()
  const router = useRouter()
  const { id } = router.query

  const [dataPassword, setDataPassword] = useState({
    old_password: '',
    new_password: '',
    confirm_password: ''
  })
  const [isLoading, setIsLoading] = useState(false)

  const setStateLocal = (key, value) => {
    setDataPassword(prevState => ({
      ...prevState,
      [key]: value
    }))
  }

  // ERROR
  const [errors, setErrors] = useState({
    status: false,
    data: {},
    message: ''
  })

  useEffect(() => {
    if (errors.status) {
      if (errors.message == 'Failed validation' && errors.data.data.errors) {
        for (let field in errors.data.data.errors) {
          let errorMessages = errors.data.data.errors[field]
          errorMessages.forEach(errorMessage => {
            toast.error(errorMessage, {
              duration: 6000,
              style: {
                padding: '16px',
                color: theme.palette.error.main,
                border: '1px solid {theme.palette.error.main}'
              },
              iconTheme: {
                primary: theme.palette.error.main,
                secondary: theme.palette.error.contrastText
              }
            })
          })
        }
      } else {
        toast.error(errors.message, {
          duration: 6000,
          style: {
            padding: '16px',
            color: theme.palette.error.main,
            border: '1px solid {theme.palette.error.main}'
          },
          iconTheme: {
            primary: theme.palette.error.main,
            secondary: theme.palette.error.contrastText
          }
        })
      }

      setErrors({
        status: false,
        data: {},
        message: ''
      })
    }
  }, [errors])

  // END ERROR

  const clickCancel = () => {
    router.back()
  }

  const handleSave = async () => {
    if (dataPassword.old_password == '') {
      setErrors({
        status: true,
        data: null,
        message: 'Old Password belum diisi.'
      })

      return
    }

    if (dataPassword.new_password == '') {
      setErrors({
        status: true,
        data: null,
        message: 'New Password belum diisi.'
      })

      return
    }

    if (dataPassword.confirm_password == '') {
      setErrors({
        status: true,
        data: null,
        message: 'Confirm Password belum diisi.'
      })

      return
    }

    if (dataPassword.new_password != dataPassword.confirm_password) {
      setErrors({
        status: true,
        data: null,
        message: 'New Password dan Confirm Password tidak sesuai.'
      })

      return
    }

    setIsLoading(true)

    let payload = {
      old_password: btoa(dataPassword.old_password),
      new_password: btoa(dataPassword.new_password),
      confirm_password: btoa(dataPassword.confirm_password)
    }

    let response = await callPost(`${endPoint.postChangePassword}`, payload)

    if (response.status) {
      setDataPassword({
        old_password: '',
        new_password: '',
        confirm_password: ''
      })

      toast.success(response.message, {
        duration: 6000,
        style: {
          padding: '16px',
          color: theme.palette.success.main,
          border: '1px solid {theme.palette.primary.main}'
        },
        iconTheme: {
          primary: theme.palette.success.main,
          secondary: theme.palette.success.contrastText
        }
      })

      router.push('/user')
    } else {
      setErrors({
        status: true,
        data: response,
        message: response.data.message
          ? response.data.message
          : response.data.error
          ? response.data.error
          : 'Gagal menghubungkan ke server'
      })
    }

    setIsLoading(false)
  }

  return (
    <Grid container spacing={6}>
      {/* <PageHeader title={<Typography variant='h4'>User Management - Create</Typography>} /> */}

      <Grid item xs={12}>
        <div style={{ position: 'relative' }}>
          {isLoading && (
            <div
              style={{
                position: 'absolute',
                top: 0,
                left: 0,
                width: '100%',
                height: '100%',
                display: 'flex',
                justifyContent: 'center',
                alignItems: 'center',
                backgroundColor: 'rgb(187 187 187 / 50%)',
                zIndex: 1100
              }}
            >
              <CircularProgress />
            </div>
          )}
          <Card>
            <CardHeader title='Change Password' sx={{ fontSize: '13pt', padding: '16px' }} />
            <Divider sx={{ m: '0 !important' }} />
            <CardContent sx={{ p: theme => `${theme.spacing(3, 5.25, 4)} !important` }}>
              <Grid container spacing={5} sx={{ marginBottom: '15px' }}>
                <Grid item xs={12} sm={6}>
                  <CustomTextField
                    fullWidth
                    required
                    label='Old Password'
                    value={dataPassword.old_password}
                    onChange={e => setStateLocal('old_password', e.target.value)}
                  />
                </Grid>
              </Grid>
              <Grid container spacing={5} sx={{ marginBottom: '15px' }}>
                <Grid item xs={12} sm={6}>
                  <CustomTextField
                    fullWidth
                    required
                    label='New Password'
                    value={dataPassword.new_password}
                    onChange={e => setStateLocal('new_password', e.target.value)}
                  />
                </Grid>
              </Grid>
              <Grid container spacing={5} sx={{ marginBottom: '15px' }}>
                <Grid item xs={12} sm={6}>
                  <CustomTextField
                    fullWidth
                    required
                    label='Confirm Password'
                    value={dataPassword.confirm_password}
                    onChange={e => setStateLocal('confirm_password', e.target.value)}
                  />
                </Grid>
              </Grid>
            </CardContent>
            <Divider sx={{ m: '0 !important' }} />
            <CardActions sx={{ display: 'flex', justifyContent: 'end' }}>
              <Button sx={{ mr: 2 }} color='primary' variant='contained' onClick={handleSave}>
                Save
              </Button>
              <Button color='secondary' variant='contained' onClick={clickCancel}>
                Cancel
              </Button>
            </CardActions>
          </Card>
        </div>
      </Grid>
    </Grid>
  )
}

export default UserCreate
