// ** Next Import
import { useState, useEffect } from 'react'
import { useRouter } from 'next/router'
import { useTheme } from '@mui/material/styles'

// ** MUI Imports
import Grid from '@mui/material/Grid'
import Card from '@mui/material/Card'
import Typography from '@mui/material/Typography'
import CardHeader from '@mui/material/CardHeader'
import CustomTextField from 'src/@core/components/mui/text-field'
import CardContent from '@mui/material/CardContent'
import toast from 'react-hot-toast'
import Button from '@mui/material/Button'
import Checkbox from '@mui/material/Checkbox'
import FormLabel from '@mui/material/FormLabel'
import CardActions from '@mui/material/CardActions'
import CircularProgress from '@mui/material/CircularProgress'
import btoa from 'btoa'

// wysiwyg
import { EditorState, ContentState, convertToRaw, convertFromRaw } from 'draft-js'
import draftToHtml from 'draftjs-to-html'
import htmlToDraft from 'html-to-draftjs'
import ReactDraftWysiwyg from 'src/@core/components/react-draft-wysiwyg'
import { EditorWrapper } from 'src/@core/styles/libs/react-draft-wysiwyg'
import 'react-draft-wysiwyg/dist/react-draft-wysiwyg.css'

import Divider from '@mui/material/Divider'

// ** Custom Components Imports
import PageHeader from 'src/@core/components/page-header'

// PGN
import { endPoint } from 'src/service/constans'
import { callGet, callPost } from 'src/service/api'

const KetentuanUmum = () => {
  const theme = useTheme()
  const router = useRouter()
  const { id } = router.query

  // ERROR
  const [errors, setErrors] = useState({
    status: false,
    data: {},
    message: ''
  })

  useEffect(() => {
    if (errors.status) {
      if (errors.message == 'Failed validation' && errors.data.data.errors) {
        for (let field in errors.data.data.errors) {
          let errorMessages = errors.data.data.errors[field]
          errorMessages.forEach(errorMessage => {
            toast.error(errorMessage, {
              duration: 6000,
              style: {
                padding: '16px',
                color: theme.palette.error.main,
                border: '1px solid {theme.palette.error.main}'
              },
              iconTheme: {
                primary: theme.palette.error.main,
                secondary: theme.palette.error.contrastText
              }
            })
          })
        }
      } else {
        toast.error(errors.message, {
          duration: 6000,
          style: {
            padding: '16px',
            color: theme.palette.error.main,
            border: '1px solid {theme.palette.error.main}'
          },
          iconTheme: {
            primary: theme.palette.error.main,
            secondary: theme.palette.error.contrastText
          }
        })
      }

      setErrors({
        status: false,
        data: {},
        message: ''
      })
    }
  }, [errors])

  // END ERROR

  const [dataDetail, setDataDetail] = useState(null)
  const [value, setValue] = useState(EditorState.createEmpty())
  const [isLoading, setIsLoading] = useState(false)

  useEffect(() => {
    getDetail()
  }, [])

  const getDetail = async () => {
    setIsLoading(true)

    let response = await callGet(`${endPoint.getKetentuanUmum}`)

    if (response.status) {
      setDataDetail(response.data.data)
      if (response.data.data && response.data.data.konten) {
        const draft = htmlToDraft(atob(response.data.data.konten))
        if (draft) {
          const contentState = ContentState.createFromBlockArray(draft.contentBlocks)
          const editorState = EditorState.createWithContent(contentState)
          setValue(editorState)
        } else {
          setValue(EditorState.createEmpty())
        }
      }
    } else {
      setDataDetail(null)
      setValue(EditorState.createEmpty())

      setErrors({
        status: true,
        data: response,
        message: response.data.message
          ? response.data.message
          : response.data.error
          ? response.data.error
          : 'Gagal menghubungkan ke server'
      })
    }

    setIsLoading(false)
  }

  const cancel = () => {
    router.back()
  }

  const save = async () => {
    setIsLoading(true)

    const contentState = value.getCurrentContent()
    const rawContentState = convertToRaw(contentState)
    const fullContent = draftToHtml(rawContentState)
    const encodedContent = btoa(fullContent)

    const payload = {
      konten: encodedContent
    }

    let response = await callPost(`${endPoint.getKetentuanUmum}`, payload)

    if (response.status) {
      setDataDetail(null)

      toast.success(response.message, {
        duration: 6000,
        style: {
          padding: '16px',
          color: theme.palette.success.main,
          border: '1px solid {theme.palette.primary.main}'
        },
        iconTheme: {
          primary: theme.palette.success.main,
          secondary: theme.palette.success.contrastText
        }
      })

      getDetail()
    } else {
      setErrors({
        status: true,
        data: response,
        message: response.data.message
          ? response.data.message
          : response.data.error
          ? response.data.error
          : 'Gagal menghubungkan ke server'
      })
    }

    setIsLoading(false)
  }

  return (
    <Grid container spacing={6}>
      <PageHeader title={<Typography variant='h4'>Master Konten - Ketentuan Umum</Typography>} />

      <Grid item xs={12}>
        <div style={{ position: 'relative' }}>
          {isLoading && (
            <div
              style={{
                position: 'absolute',
                top: 0,
                left: 0,
                width: '100%',
                height: '100%',
                display: 'flex',
                justifyContent: 'center',
                alignItems: 'center',
                backgroundColor: 'rgb(187 187 187 / 50%)',
                zIndex: 1100
              }}
            >
              <CircularProgress />
            </div>
          )}
          <Card>
            <CardHeader title='Konten Ketentuan Umum' sx={{ fontSize: '13pt', padding: '16px' }} />
            <Divider sx={{ m: '0 !important' }} />

            <CardContent sx={{ p: theme => `${theme.spacing(3, 5.25, 4)} !important` }}>
              <EditorWrapper>
                <ReactDraftWysiwyg editorState={value} onEditorStateChange={data => setValue(data)} />
              </EditorWrapper>
            </CardContent>

            <Divider sx={{ m: '0 !important' }} />
            <CardActions sx={{ display: 'flex', justifyContent: 'end' }}>
              <Button sx={{ mr: 2 }} color='primary' variant='contained' onClick={save}>
                Save
              </Button>
              <Button color='secondary' variant='contained' onClick={cancel}>
                Cancel
              </Button>
            </CardActions>
          </Card>
        </div>
      </Grid>
    </Grid>
  )
}

export default KetentuanUmum
