// ** React Imports
import { useState } from 'react'

// ** MUI Imports
import Grid from '@mui/material/Grid'
import Radio from '@mui/material/Radio'
import FormLabel from '@mui/material/FormLabel'
import RadioGroup from '@mui/material/RadioGroup'
import FormControl from '@mui/material/FormControl'
import FormControlLabel from '@mui/material/FormControlLabel'

// ** Custom Component Import
import CustomTextField from 'src/@core/components/mui/text-field'

const LokasiPemasangan = props => {
  return (
    <>
      <Grid container spacing={5}>
        <Grid item xs={12} sm={6}>
          <CustomTextField
            fullWidth
            label='Provinsi'
            disabled
            value={props.dataDetail && props.dataDetail.province ? props.dataDetail.province.name : ''}
          />
        </Grid>
        <Grid item xs={12} sm={6}>
          <CustomTextField
            fullWidth
            label='Kota/Kabupaten'
            disabled
            value={props.dataDetail && props.dataDetail.town ? props.dataDetail.town.name : ''}
          />
        </Grid>
        <Grid item xs={12} sm={6}>
          <CustomTextField
            fullWidth
            label='Kecamatan'
            disabled
            value={props.dataDetail && props.dataDetail.district ? props.dataDetail.district.name : ''}
          />
        </Grid>
        <Grid item xs={12} sm={6}>
          <CustomTextField
            fullWidth
            label='Kelurahan'
            disabled
            value={props.dataDetail && props.dataDetail.village ? props.dataDetail.village.name : ''}
          />
        </Grid>
        <Grid item xs={12} sm={6}>
          <CustomTextField
            fullWidth
            label='Perumahan/Jalan Utama'
            disabled
            value={props.dataDetail && props.dataDetail.housing_area ? props.dataDetail.housing_area.name : ''}
          />
        </Grid>
        <Grid item xs={12} sm={6}>
          <CustomTextField
            fullWidth
            label='Nama Perumahan/Jalan Utama'
            disabled
            value={
              props.dataDetail && props.dataDetail.nama_perumahan_jalan_utama
                ? props.dataDetail.nama_perumahan_jalan_utama
                : ''
            }
          />
        </Grid>
        <Grid item xs={12} sm={4}>
          <CustomTextField
            fullWidth
            label='RT'
            type='number'
            disabled
            value={props.dataDetail && props.dataDetail.rt ? props.dataDetail.rt : ''}
          />
        </Grid>
        <Grid item xs={12} sm={4}>
          <CustomTextField
            fullWidth
            label='RW'
            type='number'
            disabled
            value={props.dataDetail && props.dataDetail.rw ? props.dataDetail.rw : ''}
          />
        </Grid>
        <Grid item xs={12} sm={4}>
          <CustomTextField
            fullWidth
            label='Kode Pos'
            type='number'
            disabled
            value={props.dataDetail && props.dataDetail.kode_pos ? props.dataDetail.kode_pos : ''}
          />
        </Grid>
        <Grid item xs={12}>
          <CustomTextField
            multiline
            rows={3}
            fullWidth
            label='Alamat Lengkap Lokasi Pemasangan'
            disabled
            value={props.dataDetail && props.dataDetail.alamat ? props.dataDetail.alamat : ''}
          />
        </Grid>
        <Grid item xs={6}>
          <CustomTextField
            fullWidth
            label='Jenis Bangunan'
            disabled
            value={props.dataDetail && props.dataDetail.building_type ? props.dataDetail.building_type.name : ''}
          />
        </Grid>

        <Grid item xs={6}>
          <FormControl>
            <FormLabel style={{ fontSize: '10pt' }}>Status Lokasi Pemasangan</FormLabel>
            <RadioGroup
              row
              value={props.dataDetail ? props.dataDetail.status_lokasi_pemasangan : ''}
              aria-label='Status Lokasi Pemasangan'
              name='status-lokasi-pemasangan'
              disabled
            >
              <FormControlLabel value='0' control={<Radio />} label='Milik Pribadi' disabled />
              <FormControlLabel value='1' control={<Radio />} label='Milik Pemerintah' disabled />
            </RadioGroup>
          </FormControl>
        </Grid>

        <Grid item xs={6}>
          <CustomTextField
            fullWidth
            label='Latitude'
            disabled
            value={props.dataDetail && props.dataDetail.latitude ? props.dataDetail.latitude : ''}
          />
        </Grid>
        <Grid item xs={6}>
          <CustomTextField
            fullWidth
            label='Longitude'
            disabled
            value={props.dataDetail && props.dataDetail.longitude ? props.dataDetail.longitude : ''}
          />
        </Grid>
        <Grid item xs={6}>
          <CustomTextField
            fullWidth
            label='Status Kepemilikan'
            disabled
            value={props.dataDetail && props.dataDetail.status_location ? props.dataDetail.status_location.name : ''}
          />
        </Grid>
        <Grid item xs={6}>
          <CustomTextField
            fullWidth
            label='Nama Pemilik Bangunan'
            disabled
            value={
              props.dataDetail && props.dataDetail.nama_pemilik_bangunan ? props.dataDetail.nama_pemilik_bangunan : ''
            }
          />
        </Grid>
        <Grid item xs={6}>
          <CustomTextField
            fullWidth
            label='No Telpon/HP Pemilik Bangunan'
            disabled
            value={
              props.dataDetail && props.dataDetail.no_telpon_pemilik_bangunan
                ? props.dataDetail.no_telpon_pemilik_bangunan
                : ''
            }
          />
        </Grid>
      </Grid>
    </>
  )
}

export default LokasiPemasangan
