// ** React Imports
import { Fragment, useState } from 'react'

// ** MUI Imports
import Grid from '@mui/material/Grid'
import Radio from '@mui/material/Radio'
import FormLabel from '@mui/material/FormLabel'
import RadioGroup from '@mui/material/RadioGroup'
import FormControl from '@mui/material/FormControl'
import FormControlLabel from '@mui/material/FormControlLabel'
import Divider from '@mui/material/Divider'

// ** Custom Component Import
import CustomTextField from 'src/@core/components/mui/text-field'

const Penggunaan = props => {
  const BahanBakar = () => {
    let element = ''
    if (props.dataFuels) {
      element = props.dataFuels.map((item, index) => {
        let temp_value = ''
        let temp_data = props.dataDetail.fuel_usages.filter(item_2 => item_2.fuel_id == item.id)
        if (temp_data.length > 0) {
          temp_value = temp_data[0].value_unit
        }

        return (
          <Fragment key={`fragment-fuel-${index}`}>
            <Grid item xs={12} sm={6} key={`grid-fuel-${index}`}>
              <CustomTextField
                fullWidth
                label={item.name}
                disabled
                value={temp_value}
                placeholder='0'
                key={`fuel-${index}`}
              />
            </Grid>
          </Fragment>
        )
      })
    }

    return <>{element}</>
  }

  const Peralatan = () => {
    let element = ''
    if (props.dataGasTools) {
      element = props.dataGasTools.map((item, index) => {
        let temp_value = ''
        let temp_data = props.dataDetail.gas_tool_usages.filter(item_2 => item_2.gas_tool_id == item.id)
        if (temp_data.length > 0) {
          temp_value = temp_data[0].amount
        }

        return (
          <Fragment key={`fragment-gas-tool-${index}`}>
            <Grid item xs={12} sm={6} key={`grid-gas-tool-${index}`}>
              <CustomTextField
                fullWidth
                label={item.name}
                disabled
                value={temp_value}
                placeholder='0'
                key={`gas-tools-${index}`}
              />
            </Grid>
          </Fragment>
        )
      })
    }

    return <>{element}</>
  }

  return (
    <>
      <Grid container spacing={5}>
        <Grid item xs={12} sm={6}>
          <CustomTextField
            fullWidth
            label='Penggunaan Energi Listrik'
            disabled
            value={props.dataDetail && props.dataDetail.electrical_power ? props.dataDetail.electrical_power.value : ''}
          />
        </Grid>
        <Grid item xs={12} sm={12}>
          <Divider sx={{ m: '0 !important' }}>Penggunaan Bahan Bakar</Divider>
        </Grid>

        <BahanBakar />

        <Grid item xs={12} sm={12}>
          <Divider sx={{ m: '0 !important' }}>Penggunaan Peralatan Gas</Divider>
        </Grid>

        <Peralatan />
      </Grid>
    </>
  )
}

export default Penggunaan
