// ** Next Import
import Link from 'next/link'

// ** MUI Imports
import Grid from '@mui/material/Grid'
import Card from '@mui/material/Card'
import { styled } from '@mui/material/styles'
import Typography from '@mui/material/Typography'
import CardHeader from '@mui/material/CardHeader'
import Button from '@mui/material/Button'
import ButtonGroup from '@mui/material/ButtonGroup'
import CustomTextField from 'src/@core/components/mui/text-field'

// ** Custom Components Imports
import PageHeader from 'src/@core/components/page-header'

import TableData from 'src/pages/register-list/tableData'

const LinkStyled = styled(Link)(({ theme }) => ({
  textDecoration: 'none',
  color: theme.palette.primary.main
}))

const RegisterList = () => {
  return (
    <Grid container spacing={6}>
      <PageHeader title={<Typography variant='h4'>Register List</Typography>} />
      <Grid item xs={12}>
        <Card>
          {/* <CardHeader></CardHeader> */}
          <TableData />
        </Card>
      </Grid>
    </Grid>
  )
}

export default RegisterList
