import axios from 'axios'

const axiosInstance = axios.create({
  baseURL: process.env.NEXT_PUBLIC_API_URL,
  withCredentials: true,
  withXSRFToken: true
})

export const callGet = async (url, params = {}) => {
  try {
    let accessToken = localStorage.getItem('accessToken')

    let headers = {
      Authorization: `Bearer ${accessToken}`
    }

    const response = await axios.get(`${process.env.NEXT_PUBLIC_API_URL}${url}`, { params, headers })

    return {
      status: true,
      data: response.data
    }
  } catch (error) {
    if (error.response) {
      console.error('Gagal menghubungkan ke server:', error.response)

      if (error.response.data.message == 'Unauthenticated.') {
        localStorage.clear()
        window.location.reload()
      }

      return {
        status: false,
        data: error.response.data,
        message: error.response.data.message
      }
    } else if (error.request) {
      console.error('Tidak ada respons dari server')

      return {
        status: false,
        data: [],
        message: 'Gagal menghubungkan ke server'
      }
    } else {
      console.error('Gagal menghubungkan ke server:', error.message)

      return {
        status: false,
        data: [],
        message: 'Gagal menghubungkan ke server'
      }
    }
  }
}

export const callPost = async (url, payload) => {
  try {
    let accessToken = localStorage.getItem('accessToken')

    let headers = {
      Authorization: `Bearer ${accessToken}`
    }

    const response = await axios.post(`${process.env.NEXT_PUBLIC_API_URL}${url}`, payload, { headers })

    return {
      status: true,
      data: response.data.data,
      message: response.data.message
    }
  } catch (error) {
    if (error.response) {
      console.error('Gagal menghubungkan ke server:', error.response)

      if (error.response.data.message == 'Unauthenticated.') {
        localStorage.clear()
        window.location.reload()
      }

      return {
        status: false,
        data: error.response.data,
        message: error.response.data.message
      }
    } else if (error.request) {
      console.error('Tidak ada respons dari server')

      return {
        status: false,
        data: [],
        message: 'Gagal menghubungkan ke server'
      }
    } else {
      console.error('Gagal menghubungkan ke server:', error.message)

      return {
        status: false,
        data: [],
        message: 'Gagal menghubungkan ke server'
      }
    }
  }
}

export const callPut = async (url, payload) => {
  try {
    let accessToken = localStorage.getItem('accessToken')

    let headers = {
      Authorization: `Bearer ${accessToken}`
    }

    const response = await axios.put(`${process.env.NEXT_PUBLIC_API_URL}${url}`, payload, { headers })

    return {
      status: true,
      data: response.data.data,
      message: response.data.message
    }
  } catch (error) {
    if (error.response) {
      console.error('Gagal menghubungkan ke server:', error.response)

      if (error.response.data.message == 'Unauthenticated.') {
        localStorage.clear()
        window.location.reload()
      }

      return {
        status: false,
        data: error.response.data,
        message: error.response.data.message
      }
    } else if (error.request) {
      console.error('Tidak ada respons dari server')

      return {
        status: false,
        data: [],
        message: 'Gagal menghubungkan ke server'
      }
    } else {
      console.error('Gagal menghubungkan ke server:', error.message)

      return {
        status: false,
        data: [],
        message: 'Gagal menghubungkan ke server'
      }
    }
  }
}

export const callLogin = async (url, payload) => {
  try {
    let headers = {
      'Content-Type': 'application/json'
    }
    const response = await axiosInstance.post(url, payload, { headers })

    return {
      status: true,
      data: response.data.data,
      message: response.data.message
    }
  } catch (error) {
    if (error.response) {
      console.error('Gagal menghubungkan ke server:', error.response)

      return {
        status: false,
        data: error.response.data,
        message: error.response.data.message
      }
    } else if (error.request) {
      console.error('Tidak ada respons dari server')

      return {
        status: false,
        data: [],
        message: 'Gagal menghubungkan ke server'
      }
    } else {
      console.error('Gagal menghubungkan ke server:', error.message)

      return {
        status: false,
        data: [],
        message: 'Gagal menghubungkan ke server'
      }
    }
  }
}

export const callExport = async (url, params = {}) => {
  try {
    let accessToken = localStorage.getItem('accessToken')

    let headers = {
      Authorization: `Bearer ${accessToken}`
    }

    const response = await axios.get(`${process.env.NEXT_PUBLIC_API_URL}${url}`, {
      params,
      headers,
      responseType: 'blob'
    })

    return {
      status: true,
      data: response.data
    }
  } catch (error) {
    if (error.response) {
      console.error('Gagal menghubungkan ke server:', error.response)

      if (error.response.data.message == 'Unauthenticated.') {
        localStorage.clear()
        window.location.reload()
      }

      return {
        status: false,
        data: error.response.data,
        message: error.response.data.message
      }
    } else if (error.request) {
      console.error('Tidak ada respons dari server')

      return {
        status: false,
        data: [],
        message: 'Gagal menghubungkan ke server'
      }
    } else {
      console.error('Gagal menghubungkan ke server:', error.message)

      return {
        status: false,
        data: [],
        message: 'Gagal menghubungkan ke server'
      }
    }
  }
}
