'use strict';

const fetch = require('node-fetch');
const util = require('util');
const stream = require('stream');
const fs = require('fs');

const streamPipeline = util.promisify(stream.pipeline);
async function downloadFile(query, target) {
  const params = query.params ? query.params.toString() : "";
  const url = query.uri + (params ? "?" + params : "");
  const headers = query.headers;
  const response = await fetch(url, {
    headers
  });
  if (!response.ok || !response.body) {
    throw new Error(`Error downloading ${url}: ${response.status}`);
  }
  await streamPipeline(response.body, fs.createWriteStream(target));
}

exports.downloadFile = downloadFile;
