import { promises } from 'fs';
import { blankIconSet } from '../icon-set/index.mjs';
import { cleanupIconKeyword } from '../misc/keyword.mjs';
import { scanDirectory } from '../misc/scan.mjs';
import { SVG } from '../svg/index.mjs';
import { cleanupSVG } from '../svg/cleanup.mjs';
import '@iconify/utils/lib/icon/defaults';
import '@iconify/utils/lib/svg/build';
import '@iconify/utils/lib/icon-set/minify';
import '@iconify/utils/lib/icon-set/convert-info';
import '../icon-set/props.mjs';
import '@iconify/utils/lib/misc/objects';
import '@iconify/utils';
import 'cheerio';
import '../svg/cleanup/attribs.mjs';
import '../svg/data/attributes.mjs';
import '../svg/data/tags.mjs';
import '../svg/parse.mjs';
import '../svg/cleanup/bad-tags.mjs';
import '../svg/cleanup/inline-style.mjs';
import '../css/parse.mjs';
import '../css/parser/tokens.mjs';
import '../css/parser/error.mjs';
import '../css/parser/strings.mjs';
import '../css/parser/text.mjs';
import '../svg/cleanup/root-style.mjs';
import '../svg/parse-style.mjs';
import '../css/parser/export.mjs';
import '../css/parser/tree.mjs';
import '../svg/cleanup/root-svg.mjs';
import '../svg/cleanup/svgo-style.mjs';
import '../optimise/svgo.mjs';
import 'svgo';
import '@iconify/utils/lib/svg/id';

async function importDirectory(path, options = {}) {
  const files = await scanDirectory(path, (ext, file, subdir, path2) => {
    if (ext.toLowerCase() === ".svg") {
      const result = {
        file,
        ext,
        subdir,
        path: path2
      };
      return result;
    }
    return false;
  });
  const iconSet = blankIconSet(options.prefix || "");
  for (let i = 0; i < files.length; i++) {
    const file = files[i];
    const defaultKeyword = cleanupIconKeyword(file.file);
    let keyword = options.keyword ? options.keyword(file, defaultKeyword, iconSet) : defaultKeyword;
    if (keyword instanceof Promise) {
      keyword = await keyword;
    }
    if (typeof keyword !== "string" || !keyword.length) {
      continue;
    }
    try {
      const content = await promises.readFile(
        file.path + file.subdir + file.file + file.ext,
        "utf8"
      );
      const svg = new SVG(content);
      await cleanupSVG(svg);
      iconSet.fromSVG(keyword, svg);
    } catch (err) {
      if (options.ignoreImportErrors !== false) {
        throw err;
      }
    }
  }
  return iconSet;
}

export { importDirectory };
