'use strict';

const fs = require('fs');

async function scanDirectory(path, callback, subdirs = true) {
  const results = [];
  if (path.length && path.slice(-1) !== "/") {
    path += "/";
  }
  async function scan(subdir) {
    const files = await fs.promises.readdir(path + subdir);
    for (let i = 0; i < files.length; i++) {
      const filename = files[i];
      if (filename.slice(0, 1) === ".") {
        continue;
      }
      const stat = await fs.promises.stat(path + subdir + filename);
      if (stat.isDirectory()) {
        if (subdirs) {
          await scan(subdir + filename + "/");
        }
        continue;
      }
      if (!stat.isFile()) {
        continue;
      }
      const parts = filename.split(".");
      const ext = parts.length > 1 ? "." + parts.pop() : "";
      const file = parts.join(".");
      let callbackResult;
      if (callback) {
        callbackResult = callback(ext, file, subdir, path, stat);
        if (callbackResult instanceof Promise) {
          callbackResult = await callbackResult;
        }
        if (callbackResult === void 0 || callbackResult === false || callbackResult === null) {
          continue;
        }
      } else {
        callbackResult = true;
      }
      results.push(
        callbackResult === true ? subdir + filename : callbackResult
      );
    }
  }
  await scan("");
  return results;
}

exports.scanDirectory = scanDirectory;
