'use strict';

const svg_parseStyle = require('../parse-style.cjs');
require('../../css/parse.cjs');
require('../../css/parser/tokens.cjs');
require('../../css/parser/error.cjs');
require('../../css/parser/strings.cjs');
require('../../css/parser/text.cjs');
require('../../css/parser/export.cjs');
require('../../css/parser/tree.cjs');
require('../parse.cjs');

function cleanupRootStyle(svg) {
  return svg_parseStyle.parseSVGStyle(svg, (item) => {
    if (
      // If global style
      item.type === "global" && // If selector tokens contain at-rule
      item.selectorTokens.find((token) => token.type === "at-rule")
    ) {
      return;
    }
    return item.value;
  });
}

exports.cleanupRootStyle = cleanupRootStyle;
