import { SVG } from './index.js';
import { CSSRuleToken, CSSToken } from '../css/parser/types.js';
import { ParseSVGCallbackItem } from './parse.js';
import '@iconify/types';
import '@iconify/utils/lib/customisations/defaults';
import '../misc/cheerio.js';

/**
 * Item in callback
 */
interface ParseSVGStyleCallbackItemCommon {
    prop: string;
    value: string;
}
interface ParseSVGStyleCallbackItemInline extends ParseSVGStyleCallbackItemCommon {
    type: 'inline';
    item: ParseSVGCallbackItem;
}
interface ParseSVGStyleCallbackItemGlobal extends ParseSVGStyleCallbackItemCommon {
    type: 'global';
    token: CSSRuleToken;
    selectors: string[];
    selectorTokens: CSSToken[];
    prevTokens: (CSSToken | null)[];
    nextTokens: CSSToken[];
}
type ParseSVGStyleCallbackItem = ParseSVGStyleCallbackItemInline | ParseSVGStyleCallbackItemGlobal;
/**
 * Result: undefined to remove item, string to change/keep item
 */
type ParseSVGStyleCallbackResult = string | undefined;
/**
 * Callback function
 */
type ParseSVGStyleCallback = (item: ParseSVGStyleCallbackItem) => ParseSVGStyleCallbackResult | Promise<ParseSVGStyleCallbackResult>;
/**
 * Parse styles in SVG
 *
 * This function finds CSS in SVG, parses it, calls callback for each rule.
 * Callback should return new value (string) or undefined to remove rule.
 * Callback can be asynchronous.
 */
declare function parseSVGStyle(svg: SVG, callback: ParseSVGStyleCallback): Promise<void>;

export { ParseSVGStyleCallback, ParseSVGStyleCallbackItem, ParseSVGStyleCallbackResult, parseSVGStyle };
